/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$1;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$Log4jEventWrapper;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDisruptor$Log4jEventWrapperHandler;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DisruptorUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.InternalAsyncUtil;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.message.ReusableMessage;

public class AsyncLoggerConfigDisruptor
extends AbstractLifeCycle
implements AsyncLoggerConfigDelegate {
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final EventFactory<AsyncLoggerConfigDisruptor$Log4jEventWrapper> FACTORY = AsyncLoggerConfigDisruptor$Log4jEventWrapper::new;
    private static final EventFactory<AsyncLoggerConfigDisruptor$Log4jEventWrapper> MUTABLE_FACTORY = () -> new AsyncLoggerConfigDisruptor$Log4jEventWrapper(new MutableLogEvent());
    private static final EventTranslatorTwoArg<AsyncLoggerConfigDisruptor$Log4jEventWrapper, LogEvent, AsyncLoggerConfig> TRANSLATOR = (asyncLoggerConfigDisruptor$Log4jEventWrapper, l, logEvent, asyncLoggerConfig) -> {
        AsyncLoggerConfigDisruptor$Log4jEventWrapper.access$002(asyncLoggerConfigDisruptor$Log4jEventWrapper, logEvent);
        AsyncLoggerConfigDisruptor$Log4jEventWrapper.access$102(asyncLoggerConfigDisruptor$Log4jEventWrapper, asyncLoggerConfig);
    };
    private static final EventTranslatorTwoArg<AsyncLoggerConfigDisruptor$Log4jEventWrapper, LogEvent, AsyncLoggerConfig> MUTABLE_TRANSLATOR = (asyncLoggerConfigDisruptor$Log4jEventWrapper, l, logEvent, asyncLoggerConfig) -> {
        ((MutableLogEvent)AsyncLoggerConfigDisruptor$Log4jEventWrapper.access$000(asyncLoggerConfigDisruptor$Log4jEventWrapper)).initFrom((LogEvent)logEvent);
        AsyncLoggerConfigDisruptor$Log4jEventWrapper.access$102(asyncLoggerConfigDisruptor$Log4jEventWrapper, asyncLoggerConfig);
    };
    private int ringBufferSize;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;
    private Boolean mutable = Boolean.FALSE;
    private volatile Disruptor<AsyncLoggerConfigDisruptor$Log4jEventWrapper> disruptor;
    private long backgroundThreadId;
    private EventFactory<AsyncLoggerConfigDisruptor$Log4jEventWrapper> factory;
    private EventTranslatorTwoArg<AsyncLoggerConfigDisruptor$Log4jEventWrapper, LogEvent, AsyncLoggerConfig> translator;
    private volatile boolean alreadyLoggedWarning;
    private final AsyncWaitStrategyFactory asyncWaitStrategyFactory;
    private WaitStrategy waitStrategy;
    private final Object queueFullEnqueueLock = new Object();

    public AsyncLoggerConfigDisruptor(AsyncWaitStrategyFactory asyncWaitStrategyFactory) {
        this.asyncWaitStrategyFactory = asyncWaitStrategyFactory;
    }

    WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    @Override
    public void setLogEventFactory(LogEventFactory logEventFactory) {
        this.mutable = this.mutable != false || logEventFactory instanceof ReusableLogEventFactory;
    }

    @Override
    public synchronized void start() {
        if (this.disruptor != null) {
            LOGGER.trace("AsyncLoggerConfigDisruptor not starting new disruptor for this configuration, using existing object.");
            return;
        }
        LOGGER.trace("AsyncLoggerConfigDisruptor creating new disruptor for this configuration.");
        this.ringBufferSize = DisruptorUtil.calculateRingBufferSize("AsyncLoggerConfig.RingBufferSize");
        this.waitStrategy = DisruptorUtil.createWaitStrategy("AsyncLoggerConfig.WaitStrategy", this.asyncWaitStrategyFactory);
        AsyncLoggerConfigDisruptor$1 asyncLoggerConfigDisruptor$1 = new AsyncLoggerConfigDisruptor$1(this, "AsyncLoggerConfig", true, 5);
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.translator = this.mutable != false ? MUTABLE_TRANSLATOR : TRANSLATOR;
        this.factory = this.mutable != false ? MUTABLE_FACTORY : FACTORY;
        this.disruptor = new Disruptor(this.factory, this.ringBufferSize, (ThreadFactory)asyncLoggerConfigDisruptor$1, ProducerType.MULTI, this.waitStrategy);
        ExceptionHandler<AsyncLoggerConfigDisruptor$Log4jEventWrapper> exceptionHandler = DisruptorUtil.getAsyncLoggerConfigExceptionHandler();
        this.disruptor.setDefaultExceptionHandler(exceptionHandler);
        AsyncLoggerConfigDisruptor$Log4jEventWrapperHandler[] asyncLoggerConfigDisruptor$Log4jEventWrapperHandlerArray = new AsyncLoggerConfigDisruptor$Log4jEventWrapperHandler[]{new AsyncLoggerConfigDisruptor$Log4jEventWrapperHandler(null)};
        this.disruptor.handleEventsWith((EventHandler[])asyncLoggerConfigDisruptor$Log4jEventWrapperHandlerArray);
        LOGGER.debug("Starting AsyncLoggerConfig disruptor for this configuration with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", (Object)this.disruptor.getRingBuffer().getBufferSize(), (Object)this.waitStrategy.getClass().getSimpleName(), (Object)exceptionHandler);
        this.disruptor.start();
        super.start();
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        Disruptor<AsyncLoggerConfigDisruptor$Log4jEventWrapper> disruptor = this.disruptor;
        if (disruptor == null) {
            LOGGER.trace("AsyncLoggerConfigDisruptor: disruptor for this configuration already shut down.");
            return true;
        }
        this.setStopping();
        LOGGER.trace("AsyncLoggerConfigDisruptor: shutting down disruptor for this configuration.");
        this.disruptor = null;
        for (int i = 0; AsyncLoggerConfigDisruptor.hasBacklog(disruptor) && i < 200; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            disruptor.shutdown(l, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.warn("AsyncLoggerConfigDisruptor: shutdown timed out after {} {}", (Object)l, (Object)timeUnit);
            disruptor.halt();
        }
        LOGGER.trace("AsyncLoggerConfigDisruptor: disruptor has been shut down.");
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncLoggerConfigDisruptor: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    private static boolean hasBacklog(Disruptor<?> disruptor) {
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        return !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    @Override
    public EventRoute getEventRoute(Level level) {
        int n = this.remainingDisruptorCapacity();
        if (n < 0) {
            return EventRoute.DISCARD;
        }
        return this.asyncQueueFullPolicy.getRoute(this.backgroundThreadId, level);
    }

    private int remainingDisruptorCapacity() {
        Disruptor<AsyncLoggerConfigDisruptor$Log4jEventWrapper> disruptor = this.disruptor;
        if (this.hasLog4jBeenShutDown(disruptor)) {
            return -1;
        }
        return (int)disruptor.getRingBuffer().remainingCapacity();
    }

    private boolean hasLog4jBeenShutDown(Disruptor<AsyncLoggerConfigDisruptor$Log4jEventWrapper> disruptor) {
        if (disruptor == null) {
            LOGGER.warn("Ignoring log event after log4j was shut down");
            return true;
        }
        return false;
    }

    @Override
    public void enqueueEvent(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        try {
            LogEvent logEvent2 = this.prepareEvent(logEvent);
            this.enqueue(logEvent2, asyncLoggerConfig);
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.warn("Ignoring log event after log4j was shut down: {} [{}] {}", (Object)logEvent.getLevel(), (Object)logEvent.getLoggerName(), (Object)(logEvent.getMessage().getFormattedMessage() + (logEvent.getThrown() == null ? "" : Throwables.toStringList(logEvent.getThrown()))));
        }
    }

    private LogEvent prepareEvent(LogEvent logEvent) {
        LogEvent logEvent2 = this.ensureImmutable(logEvent);
        if (logEvent2.getMessage() instanceof ReusableMessage) {
            if (logEvent2 instanceof Log4jLogEvent) {
                ((Log4jLogEvent)logEvent2).makeMessageImmutable();
            } else if (logEvent2 instanceof MutableLogEvent) {
                if (this.translator != MUTABLE_TRANSLATOR) {
                    logEvent2 = ((MutableLogEvent)logEvent2).createMemento();
                }
            } else {
                this.showWarningAboutCustomLogEventWithReusableMessage(logEvent2);
            }
        } else {
            InternalAsyncUtil.makeMessageImmutable(logEvent2.getMessage());
        }
        return logEvent2;
    }

    private void showWarningAboutCustomLogEventWithReusableMessage(LogEvent logEvent) {
        if (!this.alreadyLoggedWarning) {
            LOGGER.warn("Custom log event of type {} contains a mutable message of type {}. AsyncLoggerConfig does not know how to make an immutable copy of this message. This may result in ConcurrentModificationExceptions or incorrect log messages if the application modifies objects in the message while the background thread is writing it to the appenders.", (Object)logEvent.getClass().getName(), (Object)logEvent.getMessage().getClass().getName());
            this.alreadyLoggedWarning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        if (this.synchronizeEnqueueWhenQueueFull()) {
            Object object = this.queueFullEnqueueLock;
            synchronized (object) {
                this.disruptor.getRingBuffer().publishEvent(this.translator, (Object)logEvent, (Object)asyncLoggerConfig);
            }
        } else {
            this.disruptor.getRingBuffer().publishEvent(this.translator, (Object)logEvent, (Object)asyncLoggerConfig);
        }
    }

    private boolean synchronizeEnqueueWhenQueueFull() {
        return DisruptorUtil.ASYNC_CONFIG_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL && this.backgroundThreadId != Thread.currentThread().getId() && !(Thread.currentThread() instanceof Log4jThread);
    }

    @Override
    public boolean tryEnqueue(LogEvent logEvent, AsyncLoggerConfig asyncLoggerConfig) {
        LogEvent logEvent2 = this.prepareEvent(logEvent);
        return this.disruptor.getRingBuffer().tryPublishEvent(this.translator, (Object)logEvent2, (Object)asyncLoggerConfig);
    }

    private LogEvent ensureImmutable(LogEvent logEvent) {
        LogEvent logEvent2 = logEvent;
        if (logEvent instanceof RingBufferLogEvent) {
            logEvent2 = ((RingBufferLogEvent)logEvent).createMemento();
        }
        return logEvent2;
    }

    @Override
    public RingBufferAdmin createRingBufferAdmin(String string, String string2) {
        return RingBufferAdmin.forAsyncLoggerConfig(this.disruptor.getRingBuffer(), string, string2);
    }

    static /* synthetic */ long access$202(AsyncLoggerConfigDisruptor asyncLoggerConfigDisruptor, long l) {
        asyncLoggerConfigDisruptor.backgroundThreadId = l;
        return asyncLoggerConfigDisruptor.backgroundThreadId;
    }
}

