/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig$1;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig$Builder;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.LoggerConfig$LevelAndRefs;
import org.apache.logging.log4j.core.config.LoggerConfig$LoggerConfigPredicate;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.spi.AbstractLogger;

@Plugin(name="asyncLogger", category="Core", printObject=true)
public class AsyncLoggerConfig
extends LoggerConfig {
    private static final ThreadLocal<Boolean> ASYNC_LOGGER_ENTERED = new AsyncLoggerConfig$1();
    private final AsyncLoggerConfigDelegate delegate;

    @PluginBuilderFactory
    public static <B extends AsyncLoggerConfig$Builder<B>> B newAsyncBuilder() {
        return (B)((AsyncLoggerConfig$Builder)new AsyncLoggerConfig$Builder().asBuilder());
    }

    protected AsyncLoggerConfig(String string, List<AppenderRef> list, Filter filter, Level level, boolean bl, Property[] propertyArray, Configuration configuration, boolean bl2) {
        super(string, list, filter, level, bl, propertyArray, configuration, bl2);
        this.delegate = configuration.getAsyncLoggerConfigDelegate();
        this.delegate.setLogEventFactory(this.getLogEventFactory());
    }

    AsyncLoggerConfigDelegate getAsyncLoggerConfigDelegate() {
        return this.delegate;
    }

    @Override
    protected void log(LogEvent logEvent, LoggerConfig$LoggerConfigPredicate loggerConfig$LoggerConfigPredicate) {
        if (loggerConfig$LoggerConfigPredicate == LoggerConfig$LoggerConfigPredicate.ALL && ASYNC_LOGGER_ENTERED.get() == Boolean.FALSE && this.hasAppenders()) {
            ASYNC_LOGGER_ENTERED.set(Boolean.TRUE);
            try {
                super.log(logEvent, LoggerConfig$LoggerConfigPredicate.SYNCHRONOUS_ONLY);
                this.logToAsyncDelegate(logEvent);
            }
            finally {
                ASYNC_LOGGER_ENTERED.set(Boolean.FALSE);
            }
        } else {
            super.log(logEvent, loggerConfig$LoggerConfigPredicate);
        }
    }

    @Override
    protected void callAppenders(LogEvent logEvent) {
        super.callAppenders(logEvent);
    }

    private void logToAsyncDelegate(LogEvent logEvent) {
        if (!this.isFiltered(logEvent)) {
            this.populateLazilyInitializedFields(logEvent);
            if (!this.delegate.tryEnqueue(logEvent, this)) {
                this.handleQueueFull(logEvent);
            }
        }
    }

    private void handleQueueFull(LogEvent logEvent) {
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logToAsyncLoggerConfigsOnCurrentThread(logEvent);
        } else {
            EventRoute eventRoute = this.delegate.getEventRoute(logEvent.getLevel());
            eventRoute.logMessage(this, logEvent);
        }
    }

    private void populateLazilyInitializedFields(LogEvent logEvent) {
        logEvent.getSource();
        logEvent.getThreadName();
    }

    void logInBackgroundThread(LogEvent logEvent) {
        this.delegate.enqueueEvent(logEvent, this);
    }

    void logToAsyncLoggerConfigsOnCurrentThread(LogEvent logEvent) {
        this.log(logEvent, LoggerConfig$LoggerConfigPredicate.ASYNCHRONOUS_ONLY);
    }

    private String displayName() {
        return "".equals(this.getName()) ? "root" : this.getName();
    }

    @Override
    public void start() {
        LOGGER.trace("AsyncLoggerConfig[{}] starting...", (Object)this.displayName());
        super.start();
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l, timeUnit, false);
        LOGGER.trace("AsyncLoggerConfig[{}] stopping...", (Object)this.displayName());
        this.setStopped();
        return true;
    }

    public RingBufferAdmin createRingBufferAdmin(String string) {
        return this.delegate.createRingBufferAdmin(string, this.getName());
    }

    @Deprecated
    public static LoggerConfig createLogger(String string, String string2, String string3, String string4, AppenderRef[] appenderRefArray, Property[] propertyArray, Configuration configuration, Filter filter) {
        Level level;
        if (string3 == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> list = Arrays.asList(appenderRefArray);
        try {
            level = Level.toLevel(string2, Level.ERROR);
        }
        catch (Exception exception) {
            LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", (Object)string2);
            level = Level.ERROR;
        }
        String string5 = string3.equals("root") ? "" : string3;
        boolean bl = Booleans.parseBoolean(string, true);
        return new AsyncLoggerConfig(string5, list, filter, level, bl, propertyArray, configuration, AsyncLoggerConfig.includeLocation(string4));
    }

    @Deprecated
    public static LoggerConfig createLogger(@PluginAttribute(value="additivity", defaultBoolean=true) boolean bl, @PluginAttribute(value="level") Level level, @Required(message="Loggers cannot be configured without a name") @PluginAttribute(value="name") String string, @PluginAttribute(value="includeLocation") String string2, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefArray, @PluginElement(value="Properties") Property[] propertyArray, @PluginConfiguration Configuration configuration, @PluginElement(value="Filter") Filter filter) {
        String string3 = string.equals("root") ? "" : string;
        return new AsyncLoggerConfig(string3, Arrays.asList(appenderRefArray), filter, level, bl, propertyArray, configuration, AsyncLoggerConfig.includeLocation(string2));
    }

    protected static boolean includeLocation(String string) {
        return Boolean.parseBoolean(string);
    }

    static /* synthetic */ LoggerConfig$LevelAndRefs access$000(Level level, AppenderRef[] appenderRefArray, String string, Configuration configuration) {
        return AsyncLoggerConfig.getLevelAndRefs(level, appenderRefArray, string, configuration);
    }
}

