/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.routing.Route;
import org.apache.logging.log4j.core.appender.routing.Routes$1;
import org.apache.logging.log4j.core.appender.routing.Routes$Builder;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="Routes", category="Core", printObject=true)
public final class Routes {
    private static final String LOG_EVENT_KEY = "logEvent";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Configuration configuration;
    private final String pattern;
    private final AbstractScript patternScript;
    private final Route[] routes;

    @Deprecated
    public static Routes createRoutes(String string, Route ... routeArray) {
        if (routeArray == null || routeArray.length == 0) {
            LOGGER.error("No routes configured");
            return null;
        }
        return new Routes(null, null, string, routeArray);
    }

    @PluginBuilderFactory
    public static Routes$Builder newBuilder() {
        return new Routes$Builder();
    }

    private Routes(Configuration configuration, AbstractScript abstractScript, String string, Route ... routeArray) {
        this.configuration = configuration;
        this.patternScript = abstractScript;
        this.pattern = string;
        this.routes = routeArray;
    }

    public String getPattern(LogEvent logEvent, ConcurrentMap<Object, Object> concurrentMap) {
        if (this.patternScript != null) {
            ScriptManager scriptManager = this.configuration.getScriptManager();
            Bindings bindings = scriptManager.createBindings(this.patternScript);
            bindings.put("staticVariables", (Object)concurrentMap);
            bindings.put(LOG_EVENT_KEY, (Object)logEvent);
            Object object = scriptManager.execute(this.patternScript.getName(), bindings);
            bindings.remove(LOG_EVENT_KEY);
            return Objects.toString(object, null);
        }
        return this.pattern;
    }

    public AbstractScript getPatternScript() {
        return this.patternScript;
    }

    public Route getRoute(String string) {
        for (Route route : this.routes) {
            if (!Objects.equals(route.getKey(), string)) continue;
            return route;
        }
        return null;
    }

    public Route[] getRoutes() {
        return this.routes;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean bl = true;
        for (Route route : this.routes) {
            if (!bl) {
                stringBuilder.append(',');
            }
            bl = false;
            stringBuilder.append(route.toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    /* synthetic */ Routes(Configuration configuration, AbstractScript abstractScript, String string, Route[] routeArray, Routes$1 routes$1) {
        this(configuration, abstractScript, string, routeArray);
    }
}

