/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PosixViewAttributeAction;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.util.Strings;

public class PosixViewAttributeAction$Builder
implements Builder<PosixViewAttributeAction> {
    @PluginConfiguration
    private Configuration configuration;
    private StrSubstitutor subst;
    @PluginBuilderAttribute
    @Required(message="No base path provided")
    private String basePath;
    @PluginBuilderAttribute
    private boolean followLinks = false;
    @PluginBuilderAttribute
    private int maxDepth = 1;
    @PluginElement(value="PathConditions")
    private PathCondition[] pathConditions;
    @PluginBuilderAttribute(value="filePermissions")
    private String filePermissionsString;
    private Set<PosixFilePermission> filePermissions;
    @PluginBuilderAttribute
    private String fileOwner;
    @PluginBuilderAttribute
    private String fileGroup;

    @Override
    public PosixViewAttributeAction build() {
        if (Strings.isEmpty(this.basePath)) {
            AbstractAction.LOGGER.error("Posix file attribute view action not valid because base path is empty.");
            return null;
        }
        if (this.filePermissions == null && Strings.isEmpty(this.filePermissionsString) && Strings.isEmpty(this.fileOwner) && Strings.isEmpty(this.fileGroup)) {
            AbstractAction.LOGGER.error("Posix file attribute view not valid because nor permissions, user or group defined.");
            return null;
        }
        if (!FileUtils.isFilePosixAttributeViewSupported()) {
            AbstractAction.LOGGER.warn("Posix file attribute view defined but it is not supported by this files system.");
            return null;
        }
        return new PosixViewAttributeAction(this.basePath, this.followLinks, this.maxDepth, this.pathConditions, this.subst != null ? this.subst : this.configuration.getStrSubstitutor(), this.filePermissions != null ? this.filePermissions : (this.filePermissionsString != null ? PosixFilePermissions.fromString(this.filePermissionsString) : null), this.fileOwner, this.fileGroup, null);
    }

    public PosixViewAttributeAction$Builder withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public PosixViewAttributeAction$Builder withSubst(StrSubstitutor strSubstitutor) {
        this.subst = strSubstitutor;
        return this;
    }

    public PosixViewAttributeAction$Builder withBasePath(String string) {
        this.basePath = string;
        return this;
    }

    public PosixViewAttributeAction$Builder withFollowLinks(boolean bl) {
        this.followLinks = bl;
        return this;
    }

    public PosixViewAttributeAction$Builder withMaxDepth(int n) {
        this.maxDepth = n;
        return this;
    }

    public PosixViewAttributeAction$Builder withPathConditions(PathCondition[] pathConditionArray) {
        this.pathConditions = pathConditionArray;
        return this;
    }

    public PosixViewAttributeAction$Builder withFilePermissionsString(String string) {
        this.filePermissionsString = string;
        return this;
    }

    public PosixViewAttributeAction$Builder withFilePermissions(Set<PosixFilePermission> set) {
        this.filePermissions = set;
        return this;
    }

    public PosixViewAttributeAction$Builder withFileOwner(String string) {
        this.fileOwner = string;
        return this;
    }

    public PosixViewAttributeAction$Builder withFileGroup(String string) {
        this.fileGroup = string;
        return this;
    }
}

