/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager$AsyncAction;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager$EmptyQueue;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager$FactoryData;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager$RollingFileManagerFactory;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverListener;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;

public class RollingFileManager
extends FileManager {
    private static RollingFileManager$RollingFileManagerFactory factory = new RollingFileManager$RollingFileManagerFactory(null);
    private static final int MAX_TRIES = 3;
    private static final int MIN_DURATION = 100;
    private static final FileTime EPOCH = FileTime.fromMillis(0L);
    protected long size;
    private long initialTime;
    private volatile PatternProcessor patternProcessor;
    private final Semaphore semaphore = new Semaphore(1);
    private final Log4jThreadFactory threadFactory = Log4jThreadFactory.createThreadFactory("RollingFileManager");
    private volatile TriggeringPolicy triggeringPolicy;
    private volatile RolloverStrategy rolloverStrategy;
    private volatile boolean renameEmptyFiles;
    private volatile boolean initialized;
    private volatile String fileName;
    private final boolean directWrite;
    private final CopyOnWriteArrayList<RolloverListener> rolloverListeners = new CopyOnWriteArrayList();
    private final ExecutorService asyncExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new RollingFileManager$EmptyQueue(), this.threadFactory);
    private static final AtomicReferenceFieldUpdater<RollingFileManager, TriggeringPolicy> triggeringPolicyUpdater = AtomicReferenceFieldUpdater.newUpdater(RollingFileManager.class, TriggeringPolicy.class, "triggeringPolicy");
    private static final AtomicReferenceFieldUpdater<RollingFileManager, RolloverStrategy> rolloverStrategyUpdater = AtomicReferenceFieldUpdater.newUpdater(RollingFileManager.class, RolloverStrategy.class, "rolloverStrategy");
    private static final AtomicReferenceFieldUpdater<RollingFileManager, PatternProcessor> patternProcessorUpdater = AtomicReferenceFieldUpdater.newUpdater(RollingFileManager.class, PatternProcessor.class, "patternProcessor");

    @Deprecated
    protected RollingFileManager(String string, String string2, OutputStream outputStream, boolean bl, long l, long l2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, int n, boolean bl2) {
        this(string, string2, outputStream, bl, l, l2, triggeringPolicy, rolloverStrategy, string3, layout, bl2, ByteBuffer.wrap(new byte[Constants.ENCODER_BYTE_BUFFER_SIZE]));
    }

    @Deprecated
    protected RollingFileManager(String string, String string2, OutputStream outputStream, boolean bl, long l, long l2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, boolean bl2, ByteBuffer byteBuffer) {
        super(string != null ? string : string2, outputStream, bl, false, string3, layout, bl2, byteBuffer);
        this.size = l;
        this.initialTime = l2;
        this.triggeringPolicy = triggeringPolicy;
        this.rolloverStrategy = rolloverStrategy;
        this.patternProcessor = new PatternProcessor(string2);
        this.patternProcessor.setPrevFileTime(l2);
        this.fileName = string;
        this.directWrite = rolloverStrategy instanceof DirectWriteRolloverStrategy;
    }

    @Deprecated
    protected RollingFileManager(LoggerContext loggerContext, String string, String string2, OutputStream outputStream, boolean bl, boolean bl2, long l, long l2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, boolean bl3, ByteBuffer byteBuffer) {
        super(loggerContext, string != null ? string : string2, outputStream, bl, false, bl2, string3, layout, bl3, byteBuffer);
        this.size = l;
        this.initialTime = l2;
        this.triggeringPolicy = triggeringPolicy;
        this.rolloverStrategy = rolloverStrategy;
        this.patternProcessor = new PatternProcessor(string2);
        this.patternProcessor.setPrevFileTime(l2);
        this.fileName = string;
        this.directWrite = rolloverStrategy instanceof DirectWriteRolloverStrategy;
    }

    protected RollingFileManager(LoggerContext loggerContext, String string, String string2, OutputStream outputStream, boolean bl, boolean bl2, long l, long l2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, String string4, String string5, String string6, boolean bl3, ByteBuffer byteBuffer) {
        super(loggerContext, string != null ? string : string2, outputStream, bl, false, bl2, string3, layout, string4, string5, string6, bl3, byteBuffer);
        this.size = l;
        this.initialTime = l2;
        this.patternProcessor = new PatternProcessor(string2);
        this.patternProcessor.setPrevFileTime(l2);
        this.triggeringPolicy = triggeringPolicy;
        this.rolloverStrategy = rolloverStrategy;
        this.fileName = string;
        this.directWrite = rolloverStrategy instanceof DirectFileRolloverStrategy;
    }

    public void initialize() {
        if (!this.initialized) {
            File file;
            LOGGER.debug("Initializing triggering policy {}", (Object)this.triggeringPolicy);
            this.initialized = true;
            if (this.directWrite) {
                file = new File(this.getFileName());
                if (file.exists()) {
                    this.size = file.length();
                } else {
                    ((DirectFileRolloverStrategy)((Object)this.rolloverStrategy)).clearCurrentFileName();
                }
            }
            this.triggeringPolicy.initialize(this);
            if (this.triggeringPolicy instanceof LifeCycle) {
                ((LifeCycle)((Object)this.triggeringPolicy)).start();
            }
            if (this.directWrite) {
                file = new File(this.getFileName());
                if (file.exists()) {
                    this.size = file.length();
                } else {
                    ((DirectFileRolloverStrategy)((Object)this.rolloverStrategy)).clearCurrentFileName();
                }
            }
        }
    }

    public static RollingFileManager getFileManager(String string, String string2, boolean bl, boolean bl2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, int n, boolean bl3, boolean bl4, String string4, String string5, String string6, Configuration configuration) {
        if (rolloverStrategy instanceof DirectWriteRolloverStrategy && string != null) {
            LOGGER.error("The fileName attribute must not be specified with the DirectWriteRolloverStrategy");
            return null;
        }
        String string7 = string == null ? string2 : string;
        return RollingFileManager.narrow(RollingFileManager.class, RollingFileManager.getManager(string7, new RollingFileManager$FactoryData(string, string2, bl, bl2, triggeringPolicy, rolloverStrategy, string3, layout, n, bl3, bl4, string4, string5, string6, configuration), factory));
    }

    public void addRolloverListener(RolloverListener rolloverListener) {
        this.rolloverListeners.add(rolloverListener);
    }

    public void removeRolloverListener(RolloverListener rolloverListener) {
        this.rolloverListeners.remove(rolloverListener);
    }

    @Override
    public String getFileName() {
        if (this.directWrite) {
            this.fileName = ((DirectFileRolloverStrategy)((Object)this.rolloverStrategy)).getCurrentFileName(this);
        }
        return this.fileName;
    }

    @Override
    protected void createParentDir(File file) {
        if (this.directWrite) {
            file.getParentFile().mkdirs();
        }
    }

    public boolean isDirectWrite() {
        return this.directWrite;
    }

    public FileExtension getFileExtension() {
        return this.patternProcessor.getFileExtension();
    }

    @Override
    protected synchronized void write(byte[] byArray, int n, int n2, boolean bl) {
        super.write(byArray, n, n2, bl);
    }

    @Override
    protected synchronized void writeToDestination(byte[] byArray, int n, int n2) {
        this.size += (long)n2;
        super.writeToDestination(byArray, n, n2);
    }

    public boolean isRenameEmptyFiles() {
        return this.renameEmptyFiles;
    }

    public void setRenameEmptyFiles(boolean bl) {
        this.renameEmptyFiles = bl;
    }

    public long getFileSize() {
        return this.size + (long)this.byteBuffer.position();
    }

    public long getFileTime() {
        return this.initialTime;
    }

    public synchronized void checkRollover(LogEvent logEvent) {
        if (this.triggeringPolicy.isTriggeringEvent(logEvent)) {
            this.rollover();
        }
    }

    @Override
    public boolean releaseSub(long l, TimeUnit timeUnit) {
        boolean bl;
        block13: {
            LOGGER.debug("Shutting down RollingFileManager {}", (Object)this.getName());
            boolean bl2 = true;
            if (this.triggeringPolicy instanceof LifeCycle2) {
                bl2 &= ((LifeCycle2)((Object)this.triggeringPolicy)).stop(l, timeUnit);
            } else if (this.triggeringPolicy instanceof LifeCycle) {
                ((LifeCycle)((Object)this.triggeringPolicy)).stop();
                bl2 &= true;
            }
            bl = super.releaseSub(l, timeUnit) && bl2;
            this.asyncExecutor.shutdown();
            try {
                long l2 = timeUnit.toMillis(l);
                long l3 = 100L < l2 ? l2 : 100L;
                for (int i = 1; i <= 3 && !this.asyncExecutor.isTerminated(); ++i) {
                    this.asyncExecutor.awaitTermination(l3 * (long)i, TimeUnit.MILLISECONDS);
                }
                if (this.asyncExecutor.isTerminated()) {
                    LOGGER.debug("All asynchronous threads have terminated");
                    break block13;
                }
                this.asyncExecutor.shutdownNow();
                try {
                    this.asyncExecutor.awaitTermination(l, timeUnit);
                    if (this.asyncExecutor.isTerminated()) {
                        LOGGER.debug("All asynchronous threads have terminated");
                        break block13;
                    }
                    LOGGER.debug("RollingFileManager shutting down but some asynchronous services may not have completed");
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warn("RollingFileManager stopped but some asynchronous services may not have completed.");
                }
            }
            catch (InterruptedException interruptedException) {
                this.asyncExecutor.shutdownNow();
                try {
                    this.asyncExecutor.awaitTermination(l, timeUnit);
                    if (this.asyncExecutor.isTerminated()) {
                        LOGGER.debug("All asynchronous threads have terminated");
                    }
                }
                catch (InterruptedException interruptedException2) {
                    LOGGER.warn("RollingFileManager stopped but some asynchronous services may not have completed.");
                }
                Thread.currentThread().interrupt();
            }
        }
        LOGGER.debug("RollingFileManager shutdown completed with status {}", (Object)bl);
        return bl;
    }

    public synchronized void rollover(Date date, Date date2) {
        LOGGER.debug("Rollover PrevFileTime: {}, PrevRollTime: {}", (Object)date.getTime(), (Object)date2.getTime());
        this.getPatternProcessor().setPrevFileTime(date.getTime());
        this.getPatternProcessor().setCurrentFileTime(date2.getTime());
        this.rollover();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollover() {
        if (!(this.hasOutputStream() || this.isCreateOnDemand() || this.isDirectWrite())) {
            return;
        }
        String string = this.fileName;
        if (this.rolloverListeners.size() > 0) {
            for (RolloverListener object : this.rolloverListeners) {
                try {
                    object.rolloverTriggered(string);
                }
                catch (Exception exception) {
                    LOGGER.warn("Rollover Listener {} failed with {}: {}", (Object)object.getClass().getSimpleName(), (Object)exception.getClass().getName(), (Object)exception.getMessage());
                }
            }
        }
        boolean bl = Thread.interrupted();
        try {
            if (bl) {
                LOGGER.warn("RollingFileManager cleared thread interrupted state, continue to rollover");
            }
            if (this.rollover(this.rolloverStrategy)) {
                try {
                    this.size = 0L;
                    this.initialTime = System.currentTimeMillis();
                    this.createFileAfterRollover();
                }
                catch (IOException iOException) {
                    this.logError("Failed to create file after rollover", iOException);
                }
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.rolloverListeners.size() > 0) {
            for (RolloverListener rolloverListener : this.rolloverListeners) {
                try {
                    rolloverListener.rolloverComplete(string);
                }
                catch (Exception exception) {
                    LOGGER.warn("Rollover Listener {} failed with {}: {}", (Object)rolloverListener.getClass().getSimpleName(), (Object)exception.getClass().getName(), (Object)exception.getMessage());
                }
            }
        }
    }

    protected void createFileAfterRollover() {
        this.setOutputStream(this.createOutputStream());
    }

    public PatternProcessor getPatternProcessor() {
        return this.patternProcessor;
    }

    public void setTriggeringPolicy(TriggeringPolicy triggeringPolicy) {
        triggeringPolicy.initialize(this);
        TriggeringPolicy triggeringPolicy2 = this.triggeringPolicy;
        int n = 0;
        boolean bl = false;
        while (!(bl = triggeringPolicyUpdater.compareAndSet(this, this.triggeringPolicy, triggeringPolicy)) && ++n < 3) {
        }
        if (bl) {
            if (triggeringPolicy instanceof LifeCycle) {
                ((LifeCycle)((Object)triggeringPolicy)).start();
            }
            if (triggeringPolicy2 instanceof LifeCycle) {
                ((LifeCycle)((Object)triggeringPolicy2)).stop();
            }
        } else if (triggeringPolicy instanceof LifeCycle) {
            ((LifeCycle)((Object)triggeringPolicy)).stop();
        }
    }

    public void setRolloverStrategy(RolloverStrategy rolloverStrategy) {
        rolloverStrategyUpdater.compareAndSet(this, this.rolloverStrategy, rolloverStrategy);
    }

    public void setPatternProcessor(PatternProcessor patternProcessor) {
        patternProcessorUpdater.compareAndSet(this, this.patternProcessor, patternProcessor);
    }

    public <T extends TriggeringPolicy> T getTriggeringPolicy() {
        return (T)this.triggeringPolicy;
    }

    Semaphore getSemaphore() {
        return this.semaphore;
    }

    public RolloverStrategy getRolloverStrategy() {
        return this.rolloverStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollover(RolloverStrategy rolloverStrategy) {
        boolean bl = false;
        try {
            this.semaphore.acquire();
            bl = true;
        }
        catch (InterruptedException interruptedException) {
            this.logError("Thread interrupted while attempting to check rollover", interruptedException);
            return false;
        }
        boolean bl2 = true;
        try {
            RolloverDescription rolloverDescription = rolloverStrategy.rollover(this);
            if (rolloverDescription != null) {
                this.writeFooter();
                this.closeOutputStream();
                if (rolloverDescription.getSynchronous() != null) {
                    LOGGER.debug("RollingFileManager executing synchronous {}", (Object)rolloverDescription.getSynchronous());
                    try {
                        bl2 = rolloverDescription.getSynchronous().execute();
                    }
                    catch (Exception exception) {
                        bl2 = false;
                        this.logError("Caught error in synchronous task", exception);
                    }
                }
                if (bl2 && rolloverDescription.getAsynchronous() != null) {
                    LOGGER.debug("RollingFileManager executing async {}", (Object)rolloverDescription.getAsynchronous());
                    this.asyncExecutor.execute(new RollingFileManager$AsyncAction(rolloverDescription.getAsynchronous(), this));
                    bl = false;
                }
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (bl) {
                this.semaphore.release();
            }
        }
    }

    @Override
    public void updateData(Object object) {
        RollingFileManager$FactoryData rollingFileManager$FactoryData = (RollingFileManager$FactoryData)object;
        this.setRolloverStrategy(rollingFileManager$FactoryData.getRolloverStrategy());
        this.setPatternProcessor(new PatternProcessor(rollingFileManager$FactoryData.getPattern(), this.getPatternProcessor()));
        this.setTriggeringPolicy(rollingFileManager$FactoryData.getTriggeringPolicy());
    }

    private static long initialFileTime(File file) {
        Path path = file.toPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                FileTime fileTime = basicFileAttributes.creationTime();
                if (fileTime.compareTo(EPOCH) > 0) {
                    LOGGER.debug("Returning file creation time for {}", (Object)file.getAbsolutePath());
                    return fileTime.toMillis();
                }
                LOGGER.info("Unable to obtain file creation time for " + file.getAbsolutePath());
            }
            catch (Exception exception) {
                LOGGER.info("Unable to calculate file creation time for " + file.getAbsolutePath() + ": " + exception.getMessage());
            }
        }
        return file.lastModified();
    }

    static /* synthetic */ Semaphore access$100(RollingFileManager rollingFileManager) {
        return rollingFileManager.semaphore;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ long access$900(File file) {
        return RollingFileManager.initialFileTime(file);
    }

    static /* synthetic */ void access$1800(RollingFileManager rollingFileManager, Path path) {
        rollingFileManager.defineAttributeView(path);
    }

    static /* synthetic */ Logger access$1900() {
        return LOGGER;
    }
}

