/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public final class FileSize {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final Pattern VALUE_PATTERN = Pattern.compile("([0-9]+([.,][0-9]+)?)\\s*(|K|M|G|T)B?", 2);

    private FileSize() {
    }

    public static long parse(String string, long l) {
        Matcher matcher = VALUE_PATTERN.matcher(string);
        if (matcher.matches()) {
            try {
                String string2 = matcher.group(1);
                double d = NumberFormat.getNumberInstance(Locale.ROOT).parse(string2).doubleValue();
                String string3 = matcher.group(3);
                if (string3 == null || string3.isEmpty()) {
                    return (long)d;
                }
                if (string3.equalsIgnoreCase("K")) {
                    return (long)(d * 1024.0);
                }
                if (string3.equalsIgnoreCase("M")) {
                    return (long)(d * 1048576.0);
                }
                if (string3.equalsIgnoreCase("G")) {
                    return (long)(d * 1.073741824E9);
                }
                if (string3.equalsIgnoreCase("T")) {
                    return (long)(d * 1.099511627776E12);
                }
                LOGGER.error("FileSize units not recognized: " + string);
                return l;
            }
            catch (ParseException parseException) {
                LOGGER.error("FileSize unable to parse numeric part: " + string, (Throwable)parseException);
                return l;
            }
        }
        LOGGER.error("FileSize unable to parse bytes: " + string);
        return l;
    }
}

