/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.mom.JmsManager$1;
import org.apache.logging.log4j.core.appender.mom.JmsManager$JmsManagerConfiguration;
import org.apache.logging.log4j.core.appender.mom.JmsManager$JmsManagerFactory;
import org.apache.logging.log4j.core.appender.mom.JmsManager$Reconnector;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.status.StatusLogger;

public class JmsManager
extends AbstractManager {
    static final JmsManager$JmsManagerFactory FACTORY = new JmsManager$JmsManagerFactory(null);
    private final JmsManager$JmsManagerConfiguration configuration;
    private volatile JmsManager$Reconnector reconnector;
    private volatile JndiManager jndiManager;
    private volatile Connection connection;
    private volatile Session session;
    private volatile Destination destination;
    private volatile MessageProducer messageProducer;

    public static JmsManager getJmsManager(String string, Properties properties, String string2, String string3, String string4, char[] cArray, boolean bl, long l) {
        JmsManager$JmsManagerConfiguration jmsManager$JmsManagerConfiguration = new JmsManager$JmsManagerConfiguration(properties, string2, string3, string4, cArray, bl, l);
        return JmsManager.getManager(string, FACTORY, jmsManager$JmsManagerConfiguration);
    }

    private JmsManager(String string, JmsManager$JmsManagerConfiguration jmsManager$JmsManagerConfiguration) {
        super(null, string);
        this.configuration = jmsManager$JmsManagerConfiguration;
        this.jndiManager = jmsManager$JmsManagerConfiguration.getJndiManager();
        try {
            this.connection = this.createConnection(this.jndiManager);
            this.session = this.createSession(this.connection);
            this.destination = this.createDestination(this.jndiManager);
            this.messageProducer = this.createMessageProducer(this.session, this.destination);
            this.connection.start();
        }
        catch (JMSException | NamingException throwable) {
            this.reconnector = this.createReconnector();
            this.reconnector.start();
        }
    }

    private boolean closeConnection() {
        if (this.connection == null) {
            return true;
        }
        Connection connection = this.connection;
        this.connection = null;
        try {
            connection.close();
            return true;
        }
        catch (JMSException jMSException) {
            StatusLogger.getLogger().debug("Caught exception closing JMS Connection: {} ({}); continuing JMS manager shutdown", (Object)jMSException.getLocalizedMessage(), (Object)connection, (Object)jMSException);
            return false;
        }
    }

    private boolean closeJndiManager() {
        if (this.jndiManager == null) {
            return true;
        }
        JndiManager jndiManager = this.jndiManager;
        this.jndiManager = null;
        jndiManager.close();
        return true;
    }

    private boolean closeMessageProducer() {
        if (this.messageProducer == null) {
            return true;
        }
        MessageProducer messageProducer = this.messageProducer;
        this.messageProducer = null;
        try {
            messageProducer.close();
            return true;
        }
        catch (JMSException jMSException) {
            StatusLogger.getLogger().debug("Caught exception closing JMS MessageProducer: {} ({}); continuing JMS manager shutdown", (Object)jMSException.getLocalizedMessage(), (Object)messageProducer, (Object)jMSException);
            return false;
        }
    }

    private boolean closeSession() {
        if (this.session == null) {
            return true;
        }
        Session session = this.session;
        this.session = null;
        try {
            session.close();
            return true;
        }
        catch (JMSException jMSException) {
            StatusLogger.getLogger().debug("Caught exception closing JMS Session: {} ({}); continuing JMS manager shutdown", (Object)jMSException.getLocalizedMessage(), (Object)session, (Object)jMSException);
            return false;
        }
    }

    private Connection createConnection(JndiManager jndiManager) {
        ConnectionFactory connectionFactory = (ConnectionFactory)jndiManager.lookup(this.configuration.getConnectionFactoryName());
        if (this.configuration.getUserName() != null && this.configuration.getPassword() != null) {
            return connectionFactory.createConnection(this.configuration.getUserName(), this.configuration.getPassword() == null ? null : String.valueOf(this.configuration.getPassword()));
        }
        return connectionFactory.createConnection();
    }

    private Destination createDestination(JndiManager jndiManager) {
        return (Destination)jndiManager.lookup(this.configuration.getDestinationName());
    }

    public Message createMessage(Serializable serializable) {
        if (serializable instanceof String) {
            return this.session.createTextMessage((String)((Object)serializable));
        }
        if (serializable instanceof org.apache.logging.log4j.message.MapMessage) {
            return this.map((org.apache.logging.log4j.message.MapMessage)serializable, this.session.createMapMessage());
        }
        return this.session.createObjectMessage(serializable);
    }

    private void createMessageAndSend(LogEvent logEvent, Serializable serializable) {
        Message message = this.createMessage(serializable);
        message.setJMSTimestamp(logEvent.getTimeMillis());
        this.messageProducer.send(message);
    }

    public MessageConsumer createMessageConsumer() {
        return this.session.createConsumer(this.destination);
    }

    public MessageProducer createMessageProducer(Session session, Destination destination) {
        return session.createProducer(destination);
    }

    private JmsManager$Reconnector createReconnector() {
        JmsManager$Reconnector jmsManager$Reconnector = new JmsManager$Reconnector(this, this, null);
        jmsManager$Reconnector.setDaemon(true);
        jmsManager$Reconnector.setPriority(1);
        return jmsManager$Reconnector;
    }

    private Session createSession(Connection connection) {
        return connection.createSession(false, 1);
    }

    public JmsManager$JmsManagerConfiguration getJmsManagerConfiguration() {
        return this.configuration;
    }

    JndiManager getJndiManager() {
        return this.configuration.getJndiManager();
    }

    <T> T lookup(String string) {
        return this.jndiManager.lookup(string);
    }

    private MapMessage map(org.apache.logging.log4j.message.MapMessage<?, ?> mapMessage, MapMessage mapMessage2) {
        mapMessage.forEach((string, object) -> {
            try {
                mapMessage2.setObject(string, object);
            }
            catch (JMSException jMSException) {
                throw new IllegalArgumentException(String.format("%s mapping key '%s' to value '%s': %s", ((Object)((Object)jMSException)).getClass(), string, object, jMSException.getLocalizedMessage()), jMSException);
            }
        });
        return mapMessage2;
    }

    @Override
    protected boolean releaseSub(long l, TimeUnit timeUnit) {
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        boolean bl = false;
        bl &= this.closeJndiManager();
        bl &= this.closeMessageProducer();
        bl &= this.closeSession();
        return (bl &= this.closeConnection()) && this.jndiManager.stop(l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(LogEvent logEvent, Serializable serializable) {
        if (this.messageProducer == null && this.reconnector != null && !this.configuration.isImmediateFail()) {
            this.reconnector.latch();
            if (this.messageProducer == null) {
                throw new AppenderLoggingException("Error sending to JMS Manager '" + this.getName() + "': JMS message producer not available");
            }
        }
        JmsManager jmsManager = this;
        synchronized (jmsManager) {
            block11: {
                try {
                    this.createMessageAndSend(logEvent, serializable);
                }
                catch (JMSException jMSException) {
                    if (!this.configuration.isRetry() || this.reconnector != null) break block11;
                    this.reconnector = this.createReconnector();
                    try {
                        this.closeJndiManager();
                        this.reconnector.reconnect();
                    }
                    catch (JMSException | NamingException throwable) {
                        JmsManager.logger().debug("Cannot reestablish JMS connection to {}: {}; starting reconnector thread {}", (Object)this.configuration, (Object)throwable.getLocalizedMessage(), (Object)this.reconnector.getName(), (Object)throwable);
                        this.reconnector.start();
                        throw new AppenderLoggingException(String.format("JMS exception sending to %s for %s", this.getName(), this.configuration), jMSException);
                    }
                    try {
                        this.createMessageAndSend(logEvent, serializable);
                    }
                    catch (JMSException jMSException2) {
                        throw new AppenderLoggingException(String.format("Error sending to %s after reestablishing JMS connection for %s", this.getName(), this.configuration), jMSException);
                    }
                }
            }
        }
    }

    /* synthetic */ JmsManager(String string, JmsManager$JmsManagerConfiguration jmsManager$JmsManagerConfiguration, JmsManager$1 jmsManager$1) {
        this(string, jmsManager$JmsManagerConfiguration);
    }

    static /* synthetic */ StatusLogger access$100() {
        return JmsManager.logger();
    }

    static /* synthetic */ StatusLogger access$200() {
        return JmsManager.logger();
    }

    static /* synthetic */ Connection access$300(JmsManager jmsManager, JndiManager jndiManager) {
        return jmsManager.createConnection(jndiManager);
    }

    static /* synthetic */ Session access$400(JmsManager jmsManager, Connection connection) {
        return jmsManager.createSession(connection);
    }

    static /* synthetic */ Destination access$500(JmsManager jmsManager, JndiManager jndiManager) {
        return jmsManager.createDestination(jndiManager);
    }

    static /* synthetic */ JndiManager access$602(JmsManager jmsManager, JndiManager jndiManager) {
        jmsManager.jndiManager = jndiManager;
        return jmsManager.jndiManager;
    }

    static /* synthetic */ Connection access$702(JmsManager jmsManager, Connection connection) {
        jmsManager.connection = connection;
        return jmsManager.connection;
    }

    static /* synthetic */ Session access$802(JmsManager jmsManager, Session session) {
        jmsManager.session = session;
        return jmsManager.session;
    }

    static /* synthetic */ Destination access$902(JmsManager jmsManager, Destination destination) {
        jmsManager.destination = destination;
        return jmsManager.destination;
    }

    static /* synthetic */ MessageProducer access$1002(JmsManager jmsManager, MessageProducer messageProducer) {
        jmsManager.messageProducer = messageProducer;
        return jmsManager.messageProducer;
    }

    static /* synthetic */ JmsManager$Reconnector access$1102(JmsManager jmsManager, JmsManager$Reconnector jmsManager$Reconnector) {
        jmsManager.reconnector = jmsManager$Reconnector;
        return jmsManager.reconnector;
    }

    static /* synthetic */ JmsManager$JmsManagerConfiguration access$1200(JmsManager jmsManager) {
        return jmsManager.configuration;
    }

    static /* synthetic */ StatusLogger access$1300() {
        return JmsManager.logger();
    }

    static /* synthetic */ StatusLogger access$1400() {
        return JmsManager.logger();
    }
}

