/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender$Builder;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.mom.JmsAppender;
import org.apache.logging.log4j.core.appender.mom.JmsAppender$1;
import org.apache.logging.log4j.core.appender.mom.JmsManager;
import org.apache.logging.log4j.core.appender.mom.JmsManager$JmsManagerConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.core.util.Builder;

public class JmsAppender$Builder<B extends JmsAppender$Builder<B>>
extends AbstractAppender$Builder<B>
implements Builder<JmsAppender> {
    public static final int DEFAULT_RECONNECT_INTERVAL_MILLIS = 5000;
    @PluginBuilderAttribute
    private String factoryName;
    @PluginBuilderAttribute
    private String providerUrl;
    @PluginBuilderAttribute
    private String urlPkgPrefixes;
    @PluginBuilderAttribute
    private String securityPrincipalName;
    @PluginBuilderAttribute(sensitive=true)
    private String securityCredentials;
    @PluginBuilderAttribute
    @Required(message="A javax.jms.ConnectionFactory JNDI name must be specified")
    private String factoryBindingName;
    @PluginBuilderAttribute
    @PluginAliases(value={"queueBindingName", "topicBindingName"})
    @Required(message="A javax.jms.Destination JNDI name must be specified")
    private String destinationBindingName;
    @PluginBuilderAttribute
    private String userName;
    @PluginBuilderAttribute(sensitive=true)
    private char[] password;
    @PluginBuilderAttribute
    private long reconnectIntervalMillis = 5000L;
    @PluginBuilderAttribute
    private boolean immediateFail;
    private JmsManager jmsManager;

    private JmsAppender$Builder() {
    }

    @Override
    public JmsAppender build() {
        Layout<Serializable> layout;
        JmsManager jmsManager = this.jmsManager;
        JmsManager$JmsManagerConfiguration jmsManager$JmsManagerConfiguration = null;
        if (jmsManager == null) {
            layout = JndiManager.createProperties(this.factoryName, this.providerUrl, this.urlPkgPrefixes, this.securityPrincipalName, this.securityCredentials, null);
            jmsManager$JmsManagerConfiguration = new JmsManager$JmsManagerConfiguration((Properties)((Object)layout), this.factoryBindingName, this.destinationBindingName, this.userName, this.password, false, this.reconnectIntervalMillis);
            jmsManager = AbstractManager.getManager(this.getName(), JmsManager.FACTORY, jmsManager$JmsManagerConfiguration);
        }
        if (jmsManager == null) {
            return null;
        }
        layout = this.getLayout();
        if (layout == null) {
            JmsAppender.access$000().error("No layout provided for JmsAppender");
            return null;
        }
        try {
            return new JmsAppender(this.getName(), this.getFilter(), (Layout<? extends Serializable>)layout, this.isIgnoreExceptions(), this.getPropertyArray(), jmsManager);
        }
        catch (JMSException jMSException) {
            throw new IllegalStateException(jMSException);
        }
    }

    public JmsAppender$Builder setDestinationBindingName(String string) {
        this.destinationBindingName = string;
        return this;
    }

    public JmsAppender$Builder setFactoryBindingName(String string) {
        this.factoryBindingName = string;
        return this;
    }

    public JmsAppender$Builder setFactoryName(String string) {
        this.factoryName = string;
        return this;
    }

    public JmsAppender$Builder setImmediateFail(boolean bl) {
        this.immediateFail = bl;
        return this;
    }

    public JmsAppender$Builder setJmsManager(JmsManager jmsManager) {
        this.jmsManager = jmsManager;
        return this;
    }

    public JmsAppender$Builder setPassword(char[] cArray) {
        this.password = cArray;
        return this;
    }

    @Deprecated
    public JmsAppender$Builder setPassword(String string) {
        this.password = string == null ? null : string.toCharArray();
        return this;
    }

    public JmsAppender$Builder setProviderUrl(String string) {
        this.providerUrl = string;
        return this;
    }

    public JmsAppender$Builder setReconnectIntervalMillis(long l) {
        this.reconnectIntervalMillis = l;
        return this;
    }

    public JmsAppender$Builder setSecurityCredentials(String string) {
        this.securityCredentials = string;
        return this;
    }

    public JmsAppender$Builder setSecurityPrincipalName(String string) {
        this.securityPrincipalName = string;
        return this;
    }

    public JmsAppender$Builder setUrlPkgPrefixes(String string) {
        this.urlPkgPrefixes = string;
        return this;
    }

    @Deprecated
    public JmsAppender$Builder setUsername(String string) {
        this.userName = string;
        return this;
    }

    public JmsAppender$Builder setUserName(String string) {
        this.userName = string;
        return this;
    }

    public String toString() {
        return "Builder [name=" + this.getName() + ", factoryName=" + this.factoryName + ", providerUrl=" + this.providerUrl + ", urlPkgPrefixes=" + this.urlPkgPrefixes + ", securityPrincipalName=" + this.securityPrincipalName + ", securityCredentials=" + this.securityCredentials + ", factoryBindingName=" + this.factoryBindingName + ", destinationBindingName=" + this.destinationBindingName + ", username=" + this.userName + ", layout=" + this.getLayout() + ", filter=" + this.getFilter() + ", ignoreExceptions=" + this.isIgnoreExceptions() + ", jmsManager=" + this.jmsManager + "]";
    }

    /* synthetic */ JmsAppender$Builder(JmsAppender$1 jmsAppender$1) {
        this();
    }
}

