/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.Serializable;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.DbAppenderLoggingException;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager$1;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager$FactoryData;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager$JdbcDatabaseManagerFactory;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager$Reconnector;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager$ResultSetColumnMetaData;
import org.apache.logging.log4j.core.config.plugins.convert.DateTypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.Strings;

public final class JdbcDatabaseManager
extends AbstractDatabaseManager {
    private static final JdbcDatabaseManager$JdbcDatabaseManagerFactory INSTANCE = new JdbcDatabaseManager$JdbcDatabaseManagerFactory(null);
    private final List<ColumnConfig> columnConfigs;
    private final String sqlStatement;
    private final JdbcDatabaseManager$FactoryData factoryData;
    private volatile Connection connection;
    private volatile PreparedStatement statement;
    private volatile JdbcDatabaseManager$Reconnector reconnector;
    private volatile boolean isBatchSupported;
    private volatile Map<String, JdbcDatabaseManager$ResultSetColumnMetaData> columnMetaData;

    private static void appendColumnName(int n, String string, StringBuilder stringBuilder) {
        if (n > 1) {
            stringBuilder.append(',');
        }
        stringBuilder.append(string);
    }

    private static void appendColumnNames(String string, JdbcDatabaseManager$FactoryData jdbcDatabaseManager$FactoryData, StringBuilder stringBuilder) {
        String string2;
        int n = 1;
        String string3 = "Appending {} {}[{}]: {}={} ";
        if (JdbcDatabaseManager$FactoryData.access$200(jdbcDatabaseManager$FactoryData) != null) {
            for (ColumnMapping object : JdbcDatabaseManager$FactoryData.access$200(jdbcDatabaseManager$FactoryData)) {
                string2 = object.getName();
                JdbcDatabaseManager.appendColumnName(n, string2, stringBuilder);
                JdbcDatabaseManager.logger().trace("Appending {} {}[{}]: {}={} ", (Object)string, (Object)object.getClass().getSimpleName(), (Object)n, (Object)string2, (Object)object);
                ++n;
            }
        }
        if (JdbcDatabaseManager$FactoryData.access$600(jdbcDatabaseManager$FactoryData) != null) {
            for (ColumnConfig columnConfig : JdbcDatabaseManager$FactoryData.access$600(jdbcDatabaseManager$FactoryData)) {
                string2 = columnConfig.getColumnName();
                JdbcDatabaseManager.appendColumnName(n, string2, stringBuilder);
                JdbcDatabaseManager.logger().trace("Appending {} {}[{}]: {}={} ", (Object)string, (Object)columnConfig.getClass().getSimpleName(), (Object)n, (Object)string2, (Object)columnConfig);
                ++n;
            }
        }
    }

    private static JdbcDatabaseManager$JdbcDatabaseManagerFactory getFactory() {
        return INSTANCE;
    }

    @Deprecated
    public static JdbcDatabaseManager getJDBCDatabaseManager(String string, int n, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray) {
        return JdbcDatabaseManager.getManager(string, new JdbcDatabaseManager$FactoryData(n, null, connectionSource, string2, columnConfigArray, ColumnMapping.EMPTY_ARRAY, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    @Deprecated
    public static JdbcDatabaseManager getManager(String string, int n, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray, ColumnMapping[] columnMappingArray) {
        return JdbcDatabaseManager.getManager(string, new JdbcDatabaseManager$FactoryData(n, layout, connectionSource, string2, columnConfigArray, columnMappingArray, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    @Deprecated
    public static JdbcDatabaseManager getManager(String string, int n, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray, ColumnMapping[] columnMappingArray, boolean bl, long l) {
        return JdbcDatabaseManager.getManager(string, new JdbcDatabaseManager$FactoryData(n, null, connectionSource, string2, columnConfigArray, columnMappingArray, false, 5000L, true), JdbcDatabaseManager.getFactory());
    }

    public static JdbcDatabaseManager getManager(String string, int n, Layout<? extends Serializable> layout, ConnectionSource connectionSource, String string2, ColumnConfig[] columnConfigArray, ColumnMapping[] columnMappingArray, boolean bl, long l, boolean bl2) {
        return JdbcDatabaseManager.getManager(string, new JdbcDatabaseManager$FactoryData(n, layout, connectionSource, string2, columnConfigArray, columnMappingArray, bl, l, bl2), JdbcDatabaseManager.getFactory());
    }

    private JdbcDatabaseManager(String string, String string2, List<ColumnConfig> list, JdbcDatabaseManager$FactoryData jdbcDatabaseManager$FactoryData) {
        super(string, jdbcDatabaseManager$FactoryData.getBufferSize());
        this.sqlStatement = string2;
        this.columnConfigs = list;
        this.factoryData = jdbcDatabaseManager$FactoryData;
    }

    private void checkConnection() {
        boolean bl = true;
        try {
            bl = this.isClosed(this.connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        boolean bl2 = true;
        try {
            bl2 = this.isClosed(this.statement);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!this.isRunning() || bl || bl2) {
            this.closeResources(false);
            if (this.reconnector != null && !JdbcDatabaseManager$FactoryData.access$1500(this.factoryData)) {
                this.reconnector.latch();
                if (this.connection == null) {
                    throw new AppenderLoggingException("Error writing to JDBC Manager '%s': JDBC connection not available [%s]", this.getName(), this.fieldsToString());
                }
                if (this.statement == null) {
                    throw new AppenderLoggingException("Error writing to JDBC Manager '%s': JDBC statement not available [%s].", this.getName(), this.connection, this.fieldsToString());
                }
            }
        }
    }

    protected void closeResources(boolean bl) {
        block5: {
            block4: {
                PreparedStatement preparedStatement = this.statement;
                this.statement = null;
                try {
                    Closer.close(preparedStatement);
                }
                catch (Exception exception) {
                    if (!bl) break block4;
                    this.logWarn("Failed to close SQL statement logging event or flushing buffer", exception);
                }
            }
            Connection connection = this.connection;
            this.connection = null;
            try {
                Closer.close(connection);
            }
            catch (Exception exception) {
                if (!bl) break block5;
                this.logWarn("Failed to close database connection logging event or flushing buffer", exception);
            }
        }
    }

    @Override
    protected boolean commitAndClose() {
        block8: {
            boolean bl = true;
            try {
                if (this.connection == null || this.connection.isClosed()) break block8;
                if (this.isBuffered() && this.isBatchSupported && this.statement != null) {
                    int[] nArray;
                    JdbcDatabaseManager.logger().debug("Executing batch PreparedStatement {}", (Object)this.statement);
                    try {
                        nArray = this.statement.executeBatch();
                    }
                    catch (SQLTransactionRollbackException sQLTransactionRollbackException) {
                        JdbcDatabaseManager.logger().debug("{} executing batch PreparedStatement {}, retrying.", (Object)sQLTransactionRollbackException, (Object)this.statement);
                        nArray = this.statement.executeBatch();
                    }
                    JdbcDatabaseManager.logger().debug("Batch result: {}", (Object)Arrays.toString(nArray));
                }
                JdbcDatabaseManager.logger().debug("Committing Connection {}", (Object)this.connection);
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                throw new DbAppenderLoggingException(sQLException, "Failed to commit transaction logging event or flushing buffer [%s]", this.fieldsToString());
            }
            finally {
                this.closeResources(true);
            }
        }
        return true;
    }

    private boolean commitAndCloseAll() {
        if (this.connection != null || this.statement != null) {
            try {
                this.commitAndClose();
                return true;
            }
            catch (AppenderLoggingException appenderLoggingException) {
                Throwable throwable = appenderLoggingException.getCause();
                Throwable throwable2 = throwable == null ? appenderLoggingException : throwable;
                JdbcDatabaseManager.logger().debug("{} committing and closing connection: {}", (Object)throwable2, (Object)throwable2.getClass().getSimpleName(), (Object)appenderLoggingException.toString(), (Object)appenderLoggingException);
            }
        }
        if (JdbcDatabaseManager$FactoryData.access$1600(this.factoryData) != null) {
            JdbcDatabaseManager$FactoryData.access$1600(this.factoryData).stop();
        }
        return true;
    }

    private void connectAndPrepare() {
        JdbcDatabaseManager.logger().debug("Acquiring JDBC connection from {}", (Object)this.getConnectionSource());
        this.connection = this.getConnectionSource().getConnection();
        JdbcDatabaseManager.logger().debug("Acquired JDBC connection {}", (Object)this.connection);
        JdbcDatabaseManager.logger().debug("Getting connection metadata {}", (Object)this.connection);
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        JdbcDatabaseManager.logger().debug("Connection metadata {}", (Object)databaseMetaData);
        this.isBatchSupported = databaseMetaData.supportsBatchUpdates();
        JdbcDatabaseManager.logger().debug("Connection supportsBatchUpdates: {}", (Object)this.isBatchSupported);
        this.connection.setAutoCommit(false);
        JdbcDatabaseManager.logger().debug("Preparing SQL {}", (Object)this.sqlStatement);
        this.statement = this.connection.prepareStatement(this.sqlStatement);
        JdbcDatabaseManager.logger().debug("Prepared SQL {}", (Object)this.statement);
        if (JdbcDatabaseManager$FactoryData.access$1700(this.factoryData)) {
            this.initColumnMetaData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectAndStart() {
        this.checkConnection();
        JdbcDatabaseManager jdbcDatabaseManager = this;
        synchronized (jdbcDatabaseManager) {
            try {
                this.connectAndPrepare();
            }
            catch (SQLException sQLException) {
                this.reconnectOn(sQLException);
            }
        }
    }

    private JdbcDatabaseManager$Reconnector createReconnector() {
        JdbcDatabaseManager$Reconnector jdbcDatabaseManager$Reconnector = new JdbcDatabaseManager$Reconnector(this, null);
        jdbcDatabaseManager$Reconnector.setDaemon(true);
        jdbcDatabaseManager$Reconnector.setPriority(1);
        return jdbcDatabaseManager$Reconnector;
    }

    private String createSqlSelect() {
        StringBuilder stringBuilder = new StringBuilder("select ");
        JdbcDatabaseManager.appendColumnNames("SELECT", this.factoryData, stringBuilder);
        stringBuilder.append(" from ");
        stringBuilder.append(JdbcDatabaseManager$FactoryData.access$000(this.factoryData));
        stringBuilder.append(" where 1=0");
        return stringBuilder.toString();
    }

    private String fieldsToString() {
        return String.format("columnConfigs=%s, sqlStatement=%s, factoryData=%s, connection=%s, statement=%s, reconnector=%s, isBatchSupported=%s, columnMetaData=%s", this.columnConfigs, this.sqlStatement, this.factoryData, this.connection, this.statement, this.reconnector, this.isBatchSupported, this.columnMetaData);
    }

    public ConnectionSource getConnectionSource() {
        return JdbcDatabaseManager$FactoryData.access$1600(this.factoryData);
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public String getTableName() {
        return JdbcDatabaseManager$FactoryData.access$000(this.factoryData);
    }

    private void initColumnMetaData() {
        String string = this.createSqlSelect();
        JdbcDatabaseManager.logger().debug("Getting SQL metadata for table {}: {}", (Object)JdbcDatabaseManager$FactoryData.access$000(this.factoryData), (Object)string);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(string);){
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            JdbcDatabaseManager.logger().debug("SQL metadata: {}", (Object)resultSetMetaData);
            if (resultSetMetaData != null) {
                int n = resultSetMetaData.getColumnCount();
                this.columnMetaData = new HashMap<String, JdbcDatabaseManager$ResultSetColumnMetaData>(n);
                int n2 = 0;
                int n3 = 1;
                while (n2 < n) {
                    JdbcDatabaseManager$ResultSetColumnMetaData jdbcDatabaseManager$ResultSetColumnMetaData = new JdbcDatabaseManager$ResultSetColumnMetaData(resultSetMetaData, n3);
                    this.columnMetaData.put(jdbcDatabaseManager$ResultSetColumnMetaData.getNameKey(), jdbcDatabaseManager$ResultSetColumnMetaData);
                    ++n2;
                    ++n3;
                }
            } else {
                JdbcDatabaseManager.logger().warn("{}: truncateStrings is true and ResultSetMetaData is null for statement: {}; manager will not perform truncation.", (Object)this.getClass().getSimpleName(), (Object)preparedStatement);
            }
        }
    }

    private boolean isClosed(Statement statement) {
        return statement == null || statement.isClosed();
    }

    private boolean isClosed(Connection connection) {
        return connection == null || connection.isClosed();
    }

    private void reconnectOn(Exception exception) {
        block4: {
            if (!JdbcDatabaseManager$FactoryData.access$1900(this.factoryData)) {
                throw new AppenderLoggingException("Cannot connect and prepare", exception);
            }
            if (this.reconnector == null) {
                this.reconnector = this.createReconnector();
                try {
                    this.reconnector.reconnect();
                }
                catch (SQLException sQLException) {
                    JdbcDatabaseManager.logger().debug("Cannot reestablish JDBC connection to {}: {}; starting reconnector thread {}", (Object)this.factoryData, (Object)sQLException, (Object)this.reconnector.getName(), (Object)sQLException);
                    this.reconnector.start();
                    this.reconnector.latch();
                    if (this.connection != null && this.statement != null) break block4;
                    throw new AppenderLoggingException(exception, "Error sending to %s for %s [%s]", this.getName(), this.factoryData, this.fieldsToString());
                }
            }
        }
    }

    private void setFields(MapMessage<?, ?> mapMessage) {
        IndexedReadOnlyStringMap indexedReadOnlyStringMap = mapMessage.getIndexedReadOnlyStringMap();
        String string = this.statement.getClass().getName();
        int n = 1;
        if (JdbcDatabaseManager$FactoryData.access$200(this.factoryData) != null) {
            for (ColumnMapping columnMapping : JdbcDatabaseManager$FactoryData.access$200(this.factoryData)) {
                if (columnMapping.getLiteralValue() != null) continue;
                String string2 = columnMapping.getSource();
                String string3 = Strings.isEmpty(string2) ? columnMapping.getName() : string2;
                Object v = indexedReadOnlyStringMap.getValue(string3);
                if (JdbcDatabaseManager.logger().isTraceEnabled()) {
                    String string4 = v instanceof String ? "\"" + v + "\"" : Objects.toString(v, null);
                    JdbcDatabaseManager.logger().trace("{} setObject({}, {}) for key '{}' and mapping '{}'", (Object)string, (Object)n, (Object)string4, (Object)string3, (Object)columnMapping.getName());
                }
                this.setStatementObject(n, columnMapping.getNameKey(), v);
                ++n;
            }
        }
    }

    private void setStatementObject(int n, String string, Object object) {
        if (this.statement == null) {
            throw new AppenderLoggingException("Cannot set a value when the PreparedStatement is null.");
        }
        if (object == null) {
            if (this.columnMetaData == null) {
                throw new AppenderLoggingException("Cannot set a value when the column metadata is null.");
            }
            this.statement.setNull(n, this.columnMetaData.get(string).getType());
        } else {
            this.statement.setObject(n, this.truncate(string, object));
        }
    }

    @Override
    protected boolean shutdownInternal() {
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        return this.commitAndCloseAll();
    }

    @Override
    protected void startupInternal() {
    }

    private Object truncate(String string, Object object) {
        if (object != null && JdbcDatabaseManager$FactoryData.access$1700(this.factoryData) && this.columnMetaData != null) {
            JdbcDatabaseManager$ResultSetColumnMetaData jdbcDatabaseManager$ResultSetColumnMetaData = this.columnMetaData.get(string);
            if (jdbcDatabaseManager$ResultSetColumnMetaData != null) {
                if (jdbcDatabaseManager$ResultSetColumnMetaData.isStringType()) {
                    object = jdbcDatabaseManager$ResultSetColumnMetaData.truncate(object.toString());
                }
            } else {
                JdbcDatabaseManager.logger().error("Missing ResultSetColumnMetaData for {}, connection={}, statement={}", (Object)string, (Object)this.connection, (Object)this.statement);
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void writeInternal(LogEvent logEvent, Serializable serializable) {
        StringReader stringReader = null;
        try {
            if (!this.isRunning() || this.isClosed(this.connection) || this.isClosed(this.statement)) {
                throw new AppenderLoggingException("Cannot write logging event; JDBC manager not connected to the database, running=%s, [%s]).", this.isRunning(), this.fieldsToString());
            }
            this.statement.clearParameters();
            if (serializable instanceof MapMessage) {
                this.setFields((MapMessage)serializable);
            }
            int n = 1;
            if (JdbcDatabaseManager$FactoryData.access$200(this.factoryData) != null) {
                for (ColumnMapping columnMapping : JdbcDatabaseManager$FactoryData.access$200(this.factoryData)) {
                    if (ThreadContextMap.class.isAssignableFrom(columnMapping.getType()) || ReadOnlyStringMap.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setObject(n++, logEvent.getContextData().toMap());
                        continue;
                    }
                    if (ThreadContextStack.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setObject(n++, logEvent.getContextStack().asList());
                        continue;
                    }
                    if (Date.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setObject(n++, DateTypeConverter.fromMillis(logEvent.getTimeMillis(), columnMapping.getType().asSubclass(Date.class)));
                        continue;
                    }
                    StringLayout stringLayout = columnMapping.getLayout();
                    if (stringLayout == null) continue;
                    if (Clob.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setClob(n++, new StringReader((String)stringLayout.toSerializable(logEvent)));
                        continue;
                    }
                    if (NClob.class.isAssignableFrom(columnMapping.getType())) {
                        this.statement.setNClob(n++, new StringReader((String)stringLayout.toSerializable(logEvent)));
                        continue;
                    }
                    Object obj = TypeConverters.convert((String)stringLayout.toSerializable(logEvent), columnMapping.getType(), null);
                    this.setStatementObject(n++, columnMapping.getNameKey(), obj);
                }
            }
            for (ColumnConfig columnConfig : this.columnConfigs) {
                if (columnConfig.isEventTimestamp()) {
                    this.statement.setTimestamp(n++, new Timestamp(logEvent.getTimeMillis()));
                    continue;
                }
                if (columnConfig.isClob()) {
                    stringReader = new StringReader(columnConfig.getLayout().toSerializable(logEvent));
                    if (columnConfig.isUnicode()) {
                        this.statement.setNClob(n++, stringReader);
                        continue;
                    }
                    this.statement.setClob(n++, stringReader);
                    continue;
                }
                if (columnConfig.isUnicode()) {
                    this.statement.setNString(n++, Objects.toString(this.truncate(columnConfig.getColumnNameKey(), columnConfig.getLayout().toSerializable(logEvent)), null));
                    continue;
                }
                this.statement.setString(n++, Objects.toString(this.truncate(columnConfig.getColumnNameKey(), columnConfig.getLayout().toSerializable(logEvent)), null));
            }
            if (this.isBuffered() && this.isBatchSupported) {
                JdbcDatabaseManager.logger().debug("addBatch for {}", (Object)this.statement);
                this.statement.addBatch();
            } else {
                int n2 = this.statement.executeUpdate();
                JdbcDatabaseManager.logger().debug("executeUpdate = {} for {}", (Object)n2, (Object)this.statement);
                if (n2 == 0) {
                    throw new AppenderLoggingException("No records inserted in database table for log event in JDBC manager [%s].", this.fieldsToString());
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DbAppenderLoggingException(sQLException, "Failed to insert record for log event in JDBC manager: %s [%s]", sQLException, this.fieldsToString());
            }
            catch (Throwable throwable) {
                try {
                    if (this.statement != null) {
                        this.statement.clearParameters();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                Closer.closeSilently(stringReader);
                throw throwable;
            }
        }
        try {
            if (this.statement != null) {
                this.statement.clearParameters();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Closer.closeSilently(stringReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeThrough(LogEvent logEvent, Serializable serializable) {
        this.connectAndStart();
        try {
            try {
                this.writeInternal(logEvent, serializable);
            }
            finally {
                this.commitAndClose();
            }
        }
        catch (DbAppenderLoggingException dbAppenderLoggingException) {
            this.reconnectOn(dbAppenderLoggingException);
            try {
                this.writeInternal(logEvent, serializable);
            }
            finally {
                this.commitAndClose();
            }
        }
    }

    static /* synthetic */ void access$100(String string, JdbcDatabaseManager$FactoryData jdbcDatabaseManager$FactoryData, StringBuilder stringBuilder) {
        JdbcDatabaseManager.appendColumnNames(string, jdbcDatabaseManager$FactoryData, stringBuilder);
    }

    static /* synthetic */ StatusLogger access$300() {
        return JdbcDatabaseManager.logger();
    }

    static /* synthetic */ StatusLogger access$400() {
        return JdbcDatabaseManager.logger();
    }

    static /* synthetic */ StatusLogger access$500() {
        return JdbcDatabaseManager.logger();
    }

    /* synthetic */ JdbcDatabaseManager(String string, String string2, List list, JdbcDatabaseManager$FactoryData jdbcDatabaseManager$FactoryData, JdbcDatabaseManager$1 jdbcDatabaseManager$1) {
        this(string, string2, list, jdbcDatabaseManager$FactoryData);
    }

    static /* synthetic */ void access$800(JdbcDatabaseManager jdbcDatabaseManager) {
        jdbcDatabaseManager.connectAndPrepare();
    }

    static /* synthetic */ JdbcDatabaseManager$Reconnector access$902(JdbcDatabaseManager jdbcDatabaseManager, JdbcDatabaseManager$Reconnector jdbcDatabaseManager$Reconnector) {
        jdbcDatabaseManager.reconnector = jdbcDatabaseManager$Reconnector;
        return jdbcDatabaseManager.reconnector;
    }

    static /* synthetic */ JdbcDatabaseManager$FactoryData access$1000(JdbcDatabaseManager jdbcDatabaseManager) {
        return jdbcDatabaseManager.factoryData;
    }

    static /* synthetic */ StatusLogger access$1100() {
        return JdbcDatabaseManager.logger();
    }

    static /* synthetic */ StatusLogger access$1300() {
        return JdbcDatabaseManager.logger();
    }
}

