/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.util.Arrays;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender$Builder;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcAppender;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Assert;
import org.apache.logging.log4j.core.util.Builder;

public class JdbcAppender$Builder<B extends JdbcAppender$Builder<B>>
extends AbstractDatabaseAppender$Builder<B>
implements Builder<JdbcAppender> {
    @PluginElement(value="ConnectionSource")
    @Required(message="No ConnectionSource provided")
    private ConnectionSource connectionSource;
    @PluginBuilderAttribute
    private boolean immediateFail;
    @PluginBuilderAttribute
    private int bufferSize;
    @PluginBuilderAttribute
    @Required(message="No table name provided")
    private String tableName;
    @PluginElement(value="ColumnConfigs")
    private ColumnConfig[] columnConfigs;
    @PluginElement(value="ColumnMappings")
    private ColumnMapping[] columnMappings;
    @PluginBuilderAttribute
    private boolean truncateStrings = true;
    @PluginBuilderAttribute
    private long reconnectIntervalMillis = 5000L;

    @Override
    public JdbcAppender build() {
        if (Assert.isEmpty(this.columnConfigs) && Assert.isEmpty(this.columnMappings)) {
            JdbcAppender.access$000().error("Cannot create JdbcAppender without any columns.");
            return null;
        }
        String string = "JdbcManager{name=" + this.getName() + ", bufferSize=" + this.bufferSize + ", tableName=" + this.tableName + ", columnConfigs=" + Arrays.toString(this.columnConfigs) + ", columnMappings=" + Arrays.toString(this.columnMappings) + '}';
        JdbcDatabaseManager jdbcDatabaseManager = JdbcDatabaseManager.getManager(string, this.bufferSize, this.getLayout(), this.connectionSource, this.tableName, this.columnConfigs, this.columnMappings, this.immediateFail, this.reconnectIntervalMillis, this.truncateStrings);
        if (jdbcDatabaseManager == null) {
            return null;
        }
        return new JdbcAppender(this.getName(), this.getFilter(), this.getLayout(), this.isIgnoreExceptions(), this.getPropertyArray(), jdbcDatabaseManager, null);
    }

    public long getReconnectIntervalMillis() {
        return this.reconnectIntervalMillis;
    }

    public boolean isImmediateFail() {
        return this.immediateFail;
    }

    public B setBufferSize(int n) {
        this.bufferSize = n;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public B setColumnConfigs(ColumnConfig ... columnConfigArray) {
        this.columnConfigs = columnConfigArray;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public B setColumnMappings(ColumnMapping ... columnMappingArray) {
        this.columnMappings = columnMappingArray;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public B setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public void setImmediateFail(boolean bl) {
        this.immediateFail = bl;
    }

    public void setReconnectIntervalMillis(long l) {
        this.reconnectIntervalMillis = l;
    }

    public B setTableName(String string) {
        this.tableName = string;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }

    public B setTruncateStrings(boolean bl) {
        this.truncateStrings = bl;
        return (B)((JdbcAppender$Builder)this.asBuilder());
    }
}

