/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig$1;
import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig$Builder;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="Column", category="Core", printObject=true)
public final class ColumnConfig {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String columnName;
    private final String columnNameKey;
    private final PatternLayout layout;
    private final String literalValue;
    private final boolean eventTimestamp;
    private final boolean unicode;
    private final boolean clob;

    @Deprecated
    public static ColumnConfig createColumnConfig(Configuration configuration, String string, String string2, String string3, String string4, String string5, String string6) {
        if (Strings.isEmpty(string)) {
            LOGGER.error("The column config is not valid because it does not contain a column name.");
            return null;
        }
        boolean bl = Boolean.parseBoolean(string4);
        boolean bl2 = Booleans.parseBoolean(string5, true);
        boolean bl3 = Boolean.parseBoolean(string6);
        return ColumnConfig.newBuilder().setConfiguration(configuration).setName(string).setPattern(string2).setLiteral(string3).setEventTimestamp(bl).setUnicode(bl2).setClob(bl3).build();
    }

    @PluginBuilderFactory
    public static ColumnConfig$Builder newBuilder() {
        return new ColumnConfig$Builder();
    }

    private ColumnConfig(String string, PatternLayout patternLayout, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.columnName = string;
        this.columnNameKey = ColumnMapping.toKey(string);
        this.layout = patternLayout;
        this.literalValue = string2;
        this.eventTimestamp = bl;
        this.unicode = bl2;
        this.clob = bl3;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnNameKey() {
        return this.columnNameKey;
    }

    public PatternLayout getLayout() {
        return this.layout;
    }

    public String getLiteralValue() {
        return this.literalValue;
    }

    public boolean isClob() {
        return this.clob;
    }

    public boolean isEventTimestamp() {
        return this.eventTimestamp;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public String toString() {
        return "{ name=" + this.columnName + ", layout=" + this.layout + ", literal=" + this.literalValue + ", timestamp=" + this.eventTimestamp + " }";
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    /* synthetic */ ColumnConfig(String string, PatternLayout patternLayout, String string2, boolean bl, boolean bl2, boolean bl3, ColumnConfig$1 columnConfig$1) {
        this(string, patternLayout, string2, bl, bl2, bl3);
    }
}

