/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.appender.SocketAppender$AbstractBuilder;
import org.apache.logging.log4j.core.appender.SyslogAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Builder;
import org.apache.logging.log4j.core.layout.LoggerFields;
import org.apache.logging.log4j.core.layout.Rfc5424Layout$Rfc5424LayoutBuilder;
import org.apache.logging.log4j.core.layout.SyslogLayout;
import org.apache.logging.log4j.core.layout.SyslogLayout$Builder;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.Constants;

public class SyslogAppender$Builder<B extends SyslogAppender$Builder<B>>
extends SocketAppender$AbstractBuilder<B>
implements Builder<SocketAppender> {
    @PluginBuilderAttribute(value="facility")
    private Facility facility = Facility.LOCAL0;
    @PluginBuilderAttribute(value="id")
    private String id;
    @PluginBuilderAttribute(value="enterpriseNumber")
    private String enterpriseNumber = String.valueOf(32473);
    @PluginBuilderAttribute(value="includeMdc")
    private boolean includeMdc = true;
    @PluginBuilderAttribute(value="mdcId")
    private String mdcId;
    @PluginBuilderAttribute(value="mdcPrefix")
    private String mdcPrefix;
    @PluginBuilderAttribute(value="eventPrefix")
    private String eventPrefix;
    @PluginBuilderAttribute(value="newLine")
    private boolean newLine;
    @PluginBuilderAttribute(value="newLineEscape")
    private String escapeNL;
    @PluginBuilderAttribute(value="appName")
    private String appName;
    @PluginBuilderAttribute(value="messageId")
    private String msgId;
    @PluginBuilderAttribute(value="mdcExcludes")
    private String excludes;
    @PluginBuilderAttribute(value="mdcIncludes")
    private String includes;
    @PluginBuilderAttribute(value="mdcRequired")
    private String required;
    @PluginBuilderAttribute(value="format")
    private String format;
    @PluginBuilderAttribute(value="charset")
    private Charset charsetName = StandardCharsets.UTF_8;
    @PluginBuilderAttribute(value="exceptionPattern")
    private String exceptionPattern;
    @PluginElement(value="LoggerFields")
    private LoggerFields[] loggerFields;

    @Override
    public SyslogAppender build() {
        String string;
        Protocol protocol = this.getProtocol();
        SslConfiguration sslConfiguration = this.getSslConfiguration();
        boolean bl = sslConfiguration != null || protocol == Protocol.SSL;
        Configuration configuration = this.getConfiguration();
        SyslogLayout syslogLayout = this.getLayout();
        if (syslogLayout == null) {
            AbstractStringLayout abstractStringLayout = syslogLayout = "RFC5424".equalsIgnoreCase(this.format) ? new Rfc5424Layout$Rfc5424LayoutBuilder().setFacility(this.facility).setId(this.id).setEin(this.enterpriseNumber).setIncludeMDC(this.includeMdc).setMdcId(this.mdcId).setMdcPrefix(this.mdcPrefix).setEventPrefix(this.eventPrefix).setIncludeNL(this.newLine).setEscapeNL(this.escapeNL).setAppName(this.appName).setMessageId(this.msgId).setExcludes(this.excludes).setIncludes(this.includes).setRequired(this.required).setExceptionPattern(this.exceptionPattern).setUseTLSMessageFormat(bl).setLoggerFields(this.loggerFields).setConfig(configuration).build() : ((SyslogLayout$Builder)((AbstractStringLayout$Builder)((SyslogLayout$Builder)((SyslogLayout$Builder)((SyslogLayout$Builder)SyslogLayout.newBuilder()).setFacility(this.facility)).setIncludeNewLine(this.newLine)).setEscapeNL(this.escapeNL)).setCharset(this.charsetName)).build();
        }
        if ((string = this.getName()) == null) {
            SyslogAppender.access$000().error("No name provided for SyslogAppender");
            return null;
        }
        AbstractSocketManager abstractSocketManager = SocketAppender.createSocketManager(string, protocol, this.getHost(), this.getPort(), this.getConnectTimeoutMillis(), sslConfiguration, this.getReconnectDelayMillis(), this.getImmediateFail(), syslogLayout, Constants.ENCODER_BYTE_BUFFER_SIZE, this.getSocketOptions());
        return new SyslogAppender(string, (Layout<? extends Serializable>)syslogLayout, this.getFilter(), this.isIgnoreExceptions(), this.isImmediateFlush(), abstractSocketManager, this.getAdvertise() ? configuration.getAdvertiser() : null, null);
    }

    public Facility getFacility() {
        return this.facility;
    }

    public String getId() {
        return this.id;
    }

    public String getEnterpriseNumber() {
        return this.enterpriseNumber;
    }

    public boolean isIncludeMdc() {
        return this.includeMdc;
    }

    public String getMdcId() {
        return this.mdcId;
    }

    public String getMdcPrefix() {
        return this.mdcPrefix;
    }

    public String getEventPrefix() {
        return this.eventPrefix;
    }

    public boolean isNewLine() {
        return this.newLine;
    }

    public String getEscapeNL() {
        return this.escapeNL;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getRequired() {
        return this.required;
    }

    public String getFormat() {
        return this.format;
    }

    public Charset getCharsetName() {
        return this.charsetName;
    }

    public String getExceptionPattern() {
        return this.exceptionPattern;
    }

    public LoggerFields[] getLoggerFields() {
        return this.loggerFields;
    }

    public B setFacility(Facility facility) {
        this.facility = facility;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setId(String string) {
        this.id = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setEnterpriseNumber(String string) {
        this.enterpriseNumber = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setEnterpriseNumber(int n) {
        this.enterpriseNumber = String.valueOf(n);
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setIncludeMdc(boolean bl) {
        this.includeMdc = bl;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setMdcId(String string) {
        this.mdcId = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setMdcPrefix(String string) {
        this.mdcPrefix = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setEventPrefix(String string) {
        this.eventPrefix = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setNewLine(boolean bl) {
        this.newLine = bl;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setEscapeNL(String string) {
        this.escapeNL = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setAppName(String string) {
        this.appName = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setMsgId(String string) {
        this.msgId = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setExcludes(String string) {
        this.excludes = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setIncludes(String string) {
        this.includes = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setRequired(String string) {
        this.required = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setFormat(String string) {
        this.format = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setCharsetName(Charset charset) {
        this.charsetName = charset;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setExceptionPattern(String string) {
        this.exceptionPattern = string;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }

    public B setLoggerFields(LoggerFields[] loggerFieldsArray) {
        this.loggerFields = loggerFieldsArray;
        return (B)((SyslogAppender$Builder)this.asBuilder());
    }
}

