/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.SmtpAppender$1;
import org.apache.logging.log4j.core.appender.SmtpAppender$Builder;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.core.net.MailManager;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="SMTP", category="Core", elementType="appender", printObject=true)
public final class SmtpAppender
extends AbstractAppender {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final MailManager manager;

    private SmtpAppender(String string, Filter filter, Layout<? extends Serializable> layout, MailManager mailManager, boolean bl, Property[] propertyArray) {
        super(string, filter, layout, bl, propertyArray);
        this.manager = mailManager;
    }

    public MailManager getManager() {
        return this.manager;
    }

    @PluginBuilderFactory
    public static SmtpAppender$Builder newBuilder() {
        return new SmtpAppender$Builder();
    }

    @Deprecated
    public static SmtpAppender createAppender(@PluginConfiguration Configuration configuration, @PluginAttribute(value="name") @Required String string, @PluginAttribute(value="to") String string2, @PluginAttribute(value="cc") String string3, @PluginAttribute(value="bcc") String string4, @PluginAttribute(value="from") String string5, @PluginAttribute(value="replyTo") String string6, @PluginAttribute(value="subject") String string7, @PluginAttribute(value="smtpProtocol") String string8, @PluginAttribute(value="smtpHost") String string9, @PluginAttribute(value="smtpPort", defaultString="0") @ValidPort String string10, @PluginAttribute(value="smtpUsername") String string11, @PluginAttribute(value="smtpPassword", sensitive=true) String string12, @PluginAttribute(value="smtpDebug") String string13, @PluginAttribute(value="bufferSize") String string14, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") String string15) {
        if (string == null) {
            LOGGER.error("No name provided for SmtpAppender");
            return null;
        }
        return ((SmtpAppender$Builder)((SmtpAppender$Builder)((SmtpAppender$Builder)SmtpAppender.newBuilder().setIgnoreExceptions(Booleans.parseBoolean(string15, true))).setSmtpPort(AbstractAppender.parseInt(string10, 0)).setSmtpDebug(Boolean.parseBoolean(string13)).setBufferSize(string14 == null ? 512 : Integers.parseInt(string14)).setLayout((Layout)layout)).setFilter(filter).setConfiguration(configuration != null ? configuration : new DefaultConfiguration())).build();
    }

    @Override
    public boolean isFiltered(LogEvent logEvent) {
        boolean bl = super.isFiltered(logEvent);
        if (bl) {
            this.manager.add(logEvent);
        }
        return bl;
    }

    @Override
    public void append(LogEvent logEvent) {
        this.manager.sendEvents(this.getLayout(), logEvent);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    /* synthetic */ SmtpAppender(String string, Filter filter, Layout layout, MailManager mailManager, boolean bl, Property[] propertyArray, SmtpAppender$1 smtpAppender$1) {
        this(string, filter, layout, mailManager, bl, propertyArray);
    }
}

