/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.util.Builder;

public class RollingRandomAccessFileAppender$Builder<B extends RollingRandomAccessFileAppender$Builder<B>>
extends AbstractOutputStreamAppender$Builder<B>
implements Builder<RollingRandomAccessFileAppender> {
    @PluginBuilderAttribute(value="fileName")
    private String fileName;
    @PluginBuilderAttribute(value="filePattern")
    private String filePattern;
    @PluginBuilderAttribute(value="append")
    private boolean append = true;
    @PluginElement(value="Policy")
    private TriggeringPolicy policy;
    @PluginElement(value="Strategy")
    private RolloverStrategy strategy;
    @PluginBuilderAttribute(value="advertise")
    private boolean advertise;
    @PluginBuilderAttribute(value="advertiseURI")
    private String advertiseURI;
    @PluginBuilderAttribute
    private String filePermissions;
    @PluginBuilderAttribute
    private String fileOwner;
    @PluginBuilderAttribute
    private String fileGroup;

    public RollingRandomAccessFileAppender$Builder() {
        this.withBufferSize(262144);
        this.setIgnoreExceptions(true);
        this.withImmediateFlush(true);
    }

    @Override
    public RollingRandomAccessFileAppender build() {
        int n;
        String string = this.getName();
        if (string == null) {
            RollingRandomAccessFileAppender.access$000().error("No name provided for FileAppender");
            return null;
        }
        if (this.strategy == null) {
            this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
        } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
            RollingRandomAccessFileAppender.access$100().error("RollingFileAppender '{}': When no file name is provided a DirectFileRolloverStrategy must be configured");
            return null;
        }
        if (this.filePattern == null) {
            RollingRandomAccessFileAppender.access$200().error("No filename pattern provided for FileAppender with name " + string);
            return null;
        }
        if (this.policy == null) {
            RollingRandomAccessFileAppender.access$300().error("A TriggeringPolicy must be provided");
            return null;
        }
        Layout<Serializable> layout = this.getOrCreateLayout();
        boolean bl = this.isImmediateFlush();
        RollingRandomAccessFileManager rollingRandomAccessFileManager = RollingRandomAccessFileManager.getRollingRandomAccessFileManager(this.fileName, this.filePattern, this.append, bl, n = this.getBufferSize(), this.policy, this.strategy, this.advertiseURI, layout, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration());
        if (rollingRandomAccessFileManager == null) {
            return null;
        }
        rollingRandomAccessFileManager.initialize();
        return new RollingRandomAccessFileAppender(string, layout, this.getFilter(), rollingRandomAccessFileManager, this.fileName, this.filePattern, this.isIgnoreExceptions(), bl, n, this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray(), null);
    }

    public B withFileName(String string) {
        this.fileName = string;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withFilePattern(String string) {
        this.filePattern = string;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withAppend(boolean bl) {
        this.append = bl;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withPolicy(TriggeringPolicy triggeringPolicy) {
        this.policy = triggeringPolicy;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withStrategy(RolloverStrategy rolloverStrategy) {
        this.strategy = rolloverStrategy;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withAdvertise(boolean bl) {
        this.advertise = bl;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withAdvertiseURI(String string) {
        this.advertiseURI = string;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withFilePermissions(String string) {
        this.filePermissions = string;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withFileOwner(String string) {
        this.fileOwner = string;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }

    public B withFileGroup(String string) {
        this.fileGroup = string;
        return (B)((RollingRandomAccessFileAppender$Builder)this.asBuilder());
    }
}

