/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Builder;

public class RollingFileAppender$Builder<B extends RollingFileAppender$Builder<B>>
extends AbstractOutputStreamAppender$Builder<B>
implements Builder<RollingFileAppender> {
    @PluginBuilderAttribute
    private String fileName;
    @PluginBuilderAttribute
    @Required
    private String filePattern;
    @PluginBuilderAttribute
    private boolean append = true;
    @PluginBuilderAttribute
    private boolean locking;
    @PluginElement(value="Policy")
    @Required
    private TriggeringPolicy policy;
    @PluginElement(value="Strategy")
    private RolloverStrategy strategy;
    @PluginBuilderAttribute
    private boolean advertise;
    @PluginBuilderAttribute
    private String advertiseUri;
    @PluginBuilderAttribute
    private boolean createOnDemand;
    @PluginBuilderAttribute
    private String filePermissions;
    @PluginBuilderAttribute
    private String fileOwner;
    @PluginBuilderAttribute
    private String fileGroup;

    @Override
    public RollingFileAppender build() {
        if (!this.isValid()) {
            return null;
        }
        boolean bl = this.isBufferedIo();
        int n = this.getBufferSize();
        if (!bl && n > 0) {
            RollingFileAppender.access$000().warn("RollingFileAppender '{}': The bufferSize is set to {} but bufferedIO is not true", (Object)this.getName(), (Object)n);
        }
        if (this.strategy == null) {
            this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
        } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
            RollingFileAppender.access$100().error("RollingFileAppender '{}': When no file name is provided a {} must be configured", (Object)this.getName(), (Object)DirectFileRolloverStrategy.class.getSimpleName());
            return null;
        }
        Layout<Serializable> layout = this.getOrCreateLayout();
        RollingFileManager rollingFileManager = RollingFileManager.getFileManager(this.fileName, this.filePattern, this.append, bl, this.policy, this.strategy, this.advertiseUri, layout, n, this.isImmediateFlush(), this.createOnDemand, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration());
        if (rollingFileManager == null) {
            return null;
        }
        rollingFileManager.initialize();
        return new RollingFileAppender(this.getName(), layout, this.getFilter(), rollingFileManager, this.fileName, this.filePattern, this.isIgnoreExceptions(), !bl || this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray(), null);
    }

    public String getAdvertiseUri() {
        return this.advertiseUri;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isAdvertise() {
        return this.advertise;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isCreateOnDemand() {
        return this.createOnDemand;
    }

    public boolean isLocking() {
        return this.locking;
    }

    public String getFilePermissions() {
        return this.filePermissions;
    }

    public String getFileOwner() {
        return this.fileOwner;
    }

    public String getFileGroup() {
        return this.fileGroup;
    }

    public B withAdvertise(boolean bl) {
        this.advertise = bl;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withAdvertiseUri(String string) {
        this.advertiseUri = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withAppend(boolean bl) {
        this.append = bl;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withFileName(String string) {
        this.fileName = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withCreateOnDemand(boolean bl) {
        this.createOnDemand = bl;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withLocking(boolean bl) {
        this.locking = bl;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public TriggeringPolicy getPolicy() {
        return this.policy;
    }

    public RolloverStrategy getStrategy() {
        return this.strategy;
    }

    public B withFilePattern(String string) {
        this.filePattern = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withPolicy(TriggeringPolicy triggeringPolicy) {
        this.policy = triggeringPolicy;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withStrategy(RolloverStrategy rolloverStrategy) {
        this.strategy = rolloverStrategy;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withFilePermissions(String string) {
        this.filePermissions = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withFileOwner(String string) {
        this.fileOwner = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }

    public B withFileGroup(String string) {
        this.fileGroup = string;
        return (B)((RollingFileAppender$Builder)this.asBuilder());
    }
}

