/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.RandomAccessFileManager$FactoryData;
import org.apache.logging.log4j.core.appender.RandomAccessFileManager$RandomAccessFileManagerFactory;
import org.apache.logging.log4j.core.config.Configuration;

public class RandomAccessFileManager
extends OutputStreamManager {
    static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RandomAccessFileManager$RandomAccessFileManagerFactory FACTORY = new RandomAccessFileManager$RandomAccessFileManagerFactory(null);
    private final String advertiseURI;
    private final RandomAccessFile randomAccessFile;

    protected RandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile randomAccessFile, String string, OutputStream outputStream, int n, String string2, Layout<? extends Serializable> layout, boolean bl) {
        super(loggerContext, outputStream, string, false, layout, bl, ByteBuffer.wrap(new byte[n]));
        this.randomAccessFile = randomAccessFile;
        this.advertiseURI = string2;
    }

    public static RandomAccessFileManager getFileManager(String string, boolean bl, boolean bl2, int n, String string2, Layout<? extends Serializable> layout, Configuration configuration) {
        return RandomAccessFileManager.narrow(RandomAccessFileManager.class, RandomAccessFileManager.getManager(string, new RandomAccessFileManager$FactoryData(bl, bl2, n, string2, layout, configuration), FACTORY));
    }

    @Deprecated
    public Boolean isEndOfBatch() {
        return Boolean.FALSE;
    }

    @Deprecated
    public void setEndOfBatch(boolean bl) {
    }

    @Override
    protected void writeToDestination(byte[] byArray, int n, int n2) {
        try {
            this.randomAccessFile.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            String string = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException(string, iOException);
        }
    }

    @Override
    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
    }

    @Override
    public synchronized boolean closeOutputStream() {
        this.flush();
        try {
            this.randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            this.logError("Unable to close RandomAccessFile", iOException);
            return false;
        }
    }

    public String getFileName() {
        return this.getName();
    }

    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("fileURI", this.advertiseURI);
        return hashMap;
    }
}

