/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender$Builder;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileAppender$1;
import org.apache.logging.log4j.core.appender.MemoryMappedFileAppender$Builder;
import org.apache.logging.log4j.core.appender.MemoryMappedFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable$Builder;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="MemoryMappedFile", category="Core", elementType="appender", printObject=true)
public final class MemoryMappedFileAppender
extends AbstractOutputStreamAppender<MemoryMappedFileManager> {
    private static final int BIT_POSITION_1GB = 30;
    private static final int MAX_REGION_LENGTH = 0x40000000;
    private static final int MIN_REGION_LENGTH = 256;
    private final String fileName;
    private Object advertisement;
    private final Advertiser advertiser;

    private MemoryMappedFileAppender(String string, Layout<? extends Serializable> layout, Filter filter, MemoryMappedFileManager memoryMappedFileManager, String string2, boolean bl, boolean bl2, Advertiser advertiser, Property[] propertyArray) {
        super(string, layout, filter, bl, bl2, propertyArray, memoryMappedFileManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.putAll(memoryMappedFileManager.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        }
        this.fileName = string2;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getRegionLength() {
        return ((MemoryMappedFileManager)this.getManager()).getRegionLength();
    }

    @Deprecated
    public static <B extends MemoryMappedFileAppender$Builder<B>> MemoryMappedFileAppender createAppender(String string, String string2, String string3, String string4, String string5, String string6, Layout<? extends Serializable> layout, Filter filter, String string7, String string8, Configuration configuration) {
        boolean bl = Booleans.parseBoolean(string2, true);
        boolean bl2 = Booleans.parseBoolean(string4, false);
        boolean bl3 = Booleans.parseBoolean(string6, true);
        boolean bl4 = Boolean.parseBoolean(string7);
        int n = Integers.parseInt(string5, 0x2000000);
        return ((MemoryMappedFileAppender$Builder)((MemoryMappedFileAppender$Builder)((MemoryMappedFileAppender$Builder)((MemoryMappedFileAppender$Builder)((MemoryMappedFileAppender$Builder)((MemoryMappedFileAppender$Builder)((AbstractFilterable$Builder)((MemoryMappedFileAppender$Builder)((AbstractAppender$Builder)((MemoryMappedFileAppender$Builder)((MemoryMappedFileAppender$Builder)((MemoryMappedFileAppender$Builder)MemoryMappedFileAppender.newBuilder()).setAdvertise(bl4)).setAdvertiseURI(string8)).setAppend(bl)).setConfiguration(configuration)).setFileName(string)).setFilter(filter)).setIgnoreExceptions(bl3)).withImmediateFlush(bl2)).setLayout(layout)).setName(string3)).setRegionLength(n)).build();
    }

    @PluginBuilderFactory
    public static <B extends MemoryMappedFileAppender$Builder<B>> B newBuilder() {
        return (B)((MemoryMappedFileAppender$Builder)new MemoryMappedFileAppender$Builder().asBuilder());
    }

    private static int determineValidRegionLength(String string, int n) {
        if (n > 0x40000000) {
            LOGGER.info("MemoryMappedAppender[{}] Reduced region length from {} to max length: {}", (Object)string, (Object)n, (Object)0x40000000);
            return 0x40000000;
        }
        if (n < 256) {
            LOGGER.info("MemoryMappedAppender[{}] Expanded region length from {} to min length: {}", (Object)string, (Object)n, (Object)256);
            return 256;
        }
        int n2 = Integers.ceilingNextPowerOfTwo(n);
        if (n != n2) {
            LOGGER.info("MemoryMappedAppender[{}] Rounded up region length from {} to next power of two: {}", (Object)string, (Object)n, (Object)n2);
        }
        return n2;
    }

    static /* synthetic */ int access$000(String string, int n) {
        return MemoryMappedFileAppender.determineValidRegionLength(string, n);
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    /* synthetic */ MemoryMappedFileAppender(String string, Layout layout, Filter filter, MemoryMappedFileManager memoryMappedFileManager, String string2, boolean bl, boolean bl2, Advertiser advertiser, Property[] propertyArray, MemoryMappedFileAppender$1 memoryMappedFileAppender$1) {
        this(string, layout, filter, memoryMappedFileManager, string2, bl, bl2, advertiser, propertyArray);
    }
}

