/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.HttpManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;

public class HttpURLConnectionManager
extends HttpManager {
    private static final Charset CHARSET = Charset.forName("US-ASCII");
    private final URL url;
    private final boolean isHttps;
    private final String method;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final Property[] headers;
    private final SslConfiguration sslConfiguration;
    private final boolean verifyHostname;

    public HttpURLConnectionManager(Configuration configuration, LoggerContext loggerContext, String string, URL uRL, String string2, int n, int n2, Property[] propertyArray, SslConfiguration sslConfiguration, boolean bl) {
        super(configuration, loggerContext, string);
        this.url = uRL;
        if (!uRL.getProtocol().equalsIgnoreCase("http") && !uRL.getProtocol().equalsIgnoreCase("https")) {
            throw new ConfigurationException("URL must have scheme http or https");
        }
        this.isHttps = this.url.getProtocol().equalsIgnoreCase("https");
        this.method = Objects.requireNonNull(string2, "method");
        this.connectTimeoutMillis = n;
        this.readTimeoutMillis = n2;
        this.headers = propertyArray != null ? propertyArray : Property.EMPTY_ARRAY;
        this.sslConfiguration = sslConfiguration;
        if (this.sslConfiguration != null && !this.isHttps) {
            throw new ConfigurationException("SSL configuration can only be specified with URL scheme https");
        }
        this.verifyHostname = bl;
    }

    @Override
    public void send(Layout<?> layout, LogEvent logEvent) {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod(this.method);
        if (this.connectTimeoutMillis > 0) {
            httpURLConnection.setConnectTimeout(this.connectTimeoutMillis);
        }
        if (this.readTimeoutMillis > 0) {
            httpURLConnection.setReadTimeout(this.readTimeoutMillis);
        }
        if (layout.getContentType() != null) {
            httpURLConnection.setRequestProperty("Content-Type", layout.getContentType());
        }
        for (Property throwable : this.headers) {
            httpURLConnection.setRequestProperty(throwable.getName(), throwable.evaluate(this.getConfiguration().getStrSubstitutor()));
        }
        if (this.sslConfiguration != null) {
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.sslConfiguration.getSslSocketFactory());
        }
        if (this.isHttps && !this.verifyHostname) {
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
        }
        byte[] byArray = layout.toByteArray(logEvent);
        httpURLConnection.setFixedLengthStreamingMode(byArray.length);
        httpURLConnection.connect();
        Object object = httpURLConnection.getOutputStream();
        Object iOException = null;
        try {
            ((OutputStream)object).write(byArray);
        }
        catch (Throwable throwable) {
            iOException = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (iOException != null) {
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)iOException).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)object).close();
                }
            }
        }
        object = new byte[1024];
        try {
            iOException = httpURLConnection.getInputStream();
            Throwable throwable = null;
            try {
                while (-1 != ((InputStream)iOException).read((byte[])object)) {
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            finally {
                if (iOException != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)iOException).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((InputStream)iOException).close();
                    }
                }
            }
        }
        catch (IOException iOException2) {
            StringBuilder stringBuilder = new StringBuilder();
            try (InputStream inputStream = httpURLConnection.getErrorStream();){
                stringBuilder.append(httpURLConnection.getResponseCode());
                if (httpURLConnection.getResponseMessage() != null) {
                    stringBuilder.append(' ').append(httpURLConnection.getResponseMessage());
                }
                if (inputStream != null) {
                    int n;
                    stringBuilder.append(" - ");
                    while (-1 != (n = inputStream.read((byte[])object))) {
                        stringBuilder.append(new String((byte[])object, 0, n, CHARSET));
                    }
                }
            }
            if (httpURLConnection.getResponseCode() > -1) {
                throw new IOException(stringBuilder.toString());
            }
            throw iOException2;
        }
    }
}

