/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.status.StatusLogger;

public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int MAX_EXCEPTION_COUNT = 3;
    private static final long EXCEPTION_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(5L);
    private int exceptionCount = 0;
    private long lastExceptionInstantNanos = System.nanoTime() - EXCEPTION_INTERVAL_NANOS - 1L;
    private final Appender appender;

    public DefaultErrorHandler(Appender appender) {
        this.appender = Objects.requireNonNull(appender, "appender");
    }

    @Override
    public void error(String string) {
        boolean bl = this.acquirePermit();
        if (bl) {
            LOGGER.error(string);
        }
    }

    @Override
    public void error(String string, Throwable throwable) {
        boolean bl = this.acquirePermit();
        if (bl) {
            LOGGER.error(string, throwable);
        }
        if (!this.appender.ignoreExceptions() && throwable != null && !(throwable instanceof AppenderLoggingException)) {
            throw new AppenderLoggingException(string, throwable);
        }
    }

    @Override
    public void error(String string, LogEvent logEvent, Throwable throwable) {
        boolean bl = this.acquirePermit();
        if (bl) {
            LOGGER.error(string, throwable);
        }
        if (!this.appender.ignoreExceptions() && throwable != null && !(throwable instanceof AppenderLoggingException)) {
            throw new AppenderLoggingException(string, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquirePermit() {
        long l = System.nanoTime();
        DefaultErrorHandler defaultErrorHandler = this;
        synchronized (defaultErrorHandler) {
            if (l - this.lastExceptionInstantNanos > EXCEPTION_INTERVAL_NANOS) {
                this.lastExceptionInstantNanos = l;
                return true;
            }
            if (this.exceptionCount < 3) {
                ++this.exceptionCount;
                this.lastExceptionInstantNanos = l;
                return true;
            }
            return false;
        }
    }

    public Appender getAppender() {
        return this.appender;
    }
}

