/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender$1;
import org.apache.logging.log4j.core.appender.ConsoleAppender$Builder;
import org.apache.logging.log4j.core.appender.ConsoleAppender$ConsoleManagerFactory;
import org.apache.logging.log4j.core.appender.ConsoleAppender$FactoryData;
import org.apache.logging.log4j.core.appender.ConsoleAppender$SystemErrStream;
import org.apache.logging.log4j.core.appender.ConsoleAppender$SystemOutStream;
import org.apache.logging.log4j.core.appender.ConsoleAppender$Target;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.CloseShieldOutputStream;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="Console", category="Core", elementType="appender", printObject=true)
public final class ConsoleAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    public static final String PLUGIN_NAME = "Console";
    private static final String JANSI_CLASS = "org.fusesource.jansi.WindowsAnsiOutputStream";
    private static ConsoleAppender$ConsoleManagerFactory factory = new ConsoleAppender$ConsoleManagerFactory(null);
    private static final ConsoleAppender$Target DEFAULT_TARGET = ConsoleAppender$Target.SYSTEM_OUT;
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final ConsoleAppender$Target target;

    private ConsoleAppender(String string, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager outputStreamManager, boolean bl, ConsoleAppender$Target consoleAppender$Target, Property[] propertyArray) {
        super(string, layout, filter, bl, true, propertyArray, outputStreamManager);
        this.target = consoleAppender$Target;
    }

    @Deprecated
    public static ConsoleAppender createAppender(Layout<? extends Serializable> patternLayout, Filter filter, String string, String string2, String string3, String string4) {
        if (string2 == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        boolean bl = Boolean.parseBoolean(string3);
        boolean bl2 = Booleans.parseBoolean(string4, true);
        ConsoleAppender$Target consoleAppender$Target = string == null ? DEFAULT_TARGET : ConsoleAppender$Target.valueOf(string);
        return new ConsoleAppender(string2, (Layout<? extends Serializable>)patternLayout, filter, ConsoleAppender.getManager(consoleAppender$Target, bl, false, patternLayout), bl2, consoleAppender$Target, null);
    }

    @Deprecated
    public static ConsoleAppender createAppender(Layout<? extends Serializable> patternLayout, Filter filter, ConsoleAppender$Target consoleAppender$Target, String string, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        ConsoleAppender$Target consoleAppender$Target2 = consoleAppender$Target = consoleAppender$Target == null ? ConsoleAppender$Target.SYSTEM_OUT : consoleAppender$Target;
        if (bl && bl2) {
            LOGGER.error("Cannot use both follow and direct on ConsoleAppender");
            return null;
        }
        return new ConsoleAppender(string, (Layout<? extends Serializable>)patternLayout, filter, ConsoleAppender.getManager(consoleAppender$Target, bl, bl2, patternLayout), bl3, consoleAppender$Target, null);
    }

    public static ConsoleAppender createDefaultAppenderForLayout(Layout<? extends Serializable> layout) {
        return new ConsoleAppender("DefaultConsole-" + COUNT.incrementAndGet(), layout, null, ConsoleAppender.getDefaultManager(DEFAULT_TARGET, false, false, layout), true, DEFAULT_TARGET, null);
    }

    @PluginBuilderFactory
    public static <B extends ConsoleAppender$Builder<B>> B newBuilder() {
        return (B)((ConsoleAppender$Builder)new ConsoleAppender$Builder().asBuilder());
    }

    private static OutputStreamManager getDefaultManager(ConsoleAppender$Target consoleAppender$Target, boolean bl, boolean bl2, Layout<? extends Serializable> layout) {
        OutputStream outputStream = ConsoleAppender.getOutputStream(bl, bl2, consoleAppender$Target);
        String string = consoleAppender$Target.name() + '.' + bl + '.' + bl2 + "-" + COUNT.get();
        return OutputStreamManager.getManager(string, new ConsoleAppender$FactoryData(outputStream, string, layout), factory);
    }

    private static OutputStreamManager getManager(ConsoleAppender$Target consoleAppender$Target, boolean bl, boolean bl2, Layout<? extends Serializable> layout) {
        OutputStream outputStream = ConsoleAppender.getOutputStream(bl, bl2, consoleAppender$Target);
        String string = consoleAppender$Target.name() + '.' + bl + '.' + bl2;
        return OutputStreamManager.getManager(string, new ConsoleAppender$FactoryData(outputStream, string, layout), factory);
    }

    private static OutputStream getOutputStream(boolean bl, boolean bl2, ConsoleAppender$Target consoleAppender$Target) {
        OutputStream outputStream;
        String string = Charset.defaultCharset().name();
        try {
            outputStream = consoleAppender$Target == ConsoleAppender$Target.SYSTEM_OUT ? (bl2 ? new FileOutputStream(FileDescriptor.out) : (bl ? new PrintStream((OutputStream)new ConsoleAppender$SystemOutStream(), true, string) : System.out)) : (bl2 ? new FileOutputStream(FileDescriptor.err) : (bl ? new PrintStream((OutputStream)new ConsoleAppender$SystemErrStream(), true, string) : System.err));
            outputStream = new CloseShieldOutputStream(outputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Unsupported default encoding " + string, unsupportedEncodingException);
        }
        PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
        if (!propertiesUtil.isOsWindows() || propertiesUtil.getBooleanProperty("log4j.skipJansi", true) || bl2) {
            return outputStream;
        }
        try {
            Class<?> clazz = Loader.loadClass(JANSI_CLASS);
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class);
            return new CloseShieldOutputStream((OutputStream)constructor.newInstance(outputStream));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.debug("Jansi is not installed, cannot find {}", (Object)JANSI_CLASS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.warn("{} is missing the proper constructor", (Object)JANSI_CLASS);
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to instantiate {} due to {}", (Object)JANSI_CLASS, (Object)ConsoleAppender.clean(Throwables.getRootCause(exception).toString()).trim());
        }
        return outputStream;
    }

    private static String clean(String string) {
        return string.replace('\u0000', ' ');
    }

    public ConsoleAppender$Target getTarget() {
        return this.target;
    }

    static /* synthetic */ ConsoleAppender$Target access$200() {
        return DEFAULT_TARGET;
    }

    static /* synthetic */ OutputStreamManager access$300(ConsoleAppender$Target consoleAppender$Target, boolean bl, boolean bl2, Layout layout) {
        return ConsoleAppender.getManager(consoleAppender$Target, bl, bl2, layout);
    }

    /* synthetic */ ConsoleAppender(String string, Layout layout, Filter filter, OutputStreamManager outputStreamManager, boolean bl, ConsoleAppender$Target consoleAppender$Target, Property[] propertyArray, ConsoleAppender$1 consoleAppender$1) {
        this(string, (Layout<? extends Serializable>)layout, filter, outputStreamManager, bl, consoleAppender$Target, propertyArray);
    }
}

