/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import java.security.SecureRandom;
import java.util.Arrays;

public interface Guid {
    public static final IID IID_NULL = new IID();

    public static class IID
    extends GUID {
        public IID() {
        }

        public IID(Pointer pointer) {
            super(pointer);
        }

        public IID(String string) {
            super(string);
        }

        public IID(byte[] byArray) {
            super(byArray);
        }

        public IID(GUID gUID) {
            this(gUID.toGuidString());
        }
    }

    public static class REFIID
    extends PointerType {
        public REFIID() {
        }

        public REFIID(Pointer pointer) {
            super(pointer);
        }

        public REFIID(IID iID) {
            super(iID.getPointer());
        }

        public void setValue(IID iID) {
            this.setPointer(iID.getPointer());
        }

        public IID getValue() {
            return new IID(this.getPointer());
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            REFIID rEFIID = (REFIID)object;
            return this.getValue().equals(rEFIID.getValue());
        }

        @Override
        public int hashCode() {
            return this.getValue().hashCode();
        }
    }

    public static class CLSID
    extends GUID {
        public CLSID() {
        }

        public CLSID(String string) {
            super(string);
        }

        public CLSID(GUID gUID) {
            super(gUID);
        }

        public static class ByReference
        extends GUID {
            public ByReference() {
            }

            public ByReference(GUID gUID) {
                super(gUID);
            }

            public ByReference(Pointer pointer) {
                super(pointer);
            }
        }
    }

    @Structure.FieldOrder(value={"Data1", "Data2", "Data3", "Data4"})
    public static class GUID
    extends Structure {
        public int Data1;
        public short Data2;
        public short Data3;
        public byte[] Data4 = new byte[8];

        public GUID() {
        }

        public GUID(GUID gUID) {
            this.Data1 = gUID.Data1;
            this.Data2 = gUID.Data2;
            this.Data3 = gUID.Data3;
            this.Data4 = gUID.Data4;
            this.writeFieldsToMemory();
        }

        public GUID(String string) {
            this(GUID.fromString(string));
        }

        public GUID(byte[] byArray) {
            this(GUID.fromBinary(byArray));
        }

        public GUID(Pointer pointer) {
            super(pointer);
            this.read();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            GUID gUID = (GUID)object;
            return this.Data1 == gUID.Data1 && this.Data2 == gUID.Data2 && this.Data3 == gUID.Data3 && Arrays.equals(this.Data4, gUID.Data4);
        }

        @Override
        public int hashCode() {
            return this.Data1 + this.Data2 & 65535 + this.Data3 & 65535 + Arrays.hashCode(this.Data4);
        }

        public static GUID fromBinary(byte[] byArray) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("Invalid data length: " + byArray.length);
            }
            GUID gUID = new GUID();
            long l = byArray[0] & 0xFF;
            l <<= 8;
            l |= (long)(byArray[1] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[2] & 0xFF);
            l <<= 8;
            gUID.Data1 = (int)(l |= (long)(byArray[3] & 0xFF));
            int n = byArray[4] & 0xFF;
            n <<= 8;
            gUID.Data2 = (short)(n |= byArray[5] & 0xFF);
            int n2 = byArray[6] & 0xFF;
            n2 <<= 8;
            gUID.Data3 = (short)(n2 |= byArray[7] & 0xFF);
            gUID.Data4[0] = byArray[8];
            gUID.Data4[1] = byArray[9];
            gUID.Data4[2] = byArray[10];
            gUID.Data4[3] = byArray[11];
            gUID.Data4[4] = byArray[12];
            gUID.Data4[5] = byArray[13];
            gUID.Data4[6] = byArray[14];
            gUID.Data4[7] = byArray[15];
            gUID.writeFieldsToMemory();
            return gUID;
        }

        public static GUID fromString(String string) {
            int n;
            int n2 = 0;
            char[] cArray = new char[32];
            char[] cArray2 = string.toCharArray();
            byte[] byArray = new byte[16];
            GUID gUID = new GUID();
            if (string.length() > 38) {
                throw new IllegalArgumentException("Invalid guid length: " + string.length());
            }
            for (n = 0; n < cArray2.length; ++n) {
                if (cArray2[n] == '{' || cArray2[n] == '-' || cArray2[n] == '}') continue;
                cArray[n2++] = cArray2[n];
            }
            for (n = 0; n < 32; n += 2) {
                byArray[n / 2] = (byte)((Character.digit(cArray[n], 16) << 4) + Character.digit(cArray[n + 1], 16) & 0xFF);
            }
            if (byArray.length != 16) {
                throw new IllegalArgumentException("Invalid data length: " + byArray.length);
            }
            long l = byArray[0] & 0xFF;
            l <<= 8;
            l |= (long)(byArray[1] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[2] & 0xFF);
            l <<= 8;
            gUID.Data1 = (int)(l |= (long)(byArray[3] & 0xFF));
            int n3 = byArray[4] & 0xFF;
            n3 <<= 8;
            gUID.Data2 = (short)(n3 |= byArray[5] & 0xFF);
            int n4 = byArray[6] & 0xFF;
            n4 <<= 8;
            gUID.Data3 = (short)(n4 |= byArray[7] & 0xFF);
            gUID.Data4[0] = byArray[8];
            gUID.Data4[1] = byArray[9];
            gUID.Data4[2] = byArray[10];
            gUID.Data4[3] = byArray[11];
            gUID.Data4[4] = byArray[12];
            gUID.Data4[5] = byArray[13];
            gUID.Data4[6] = byArray[14];
            gUID.Data4[7] = byArray[15];
            gUID.writeFieldsToMemory();
            return gUID;
        }

        public static GUID newGuid() {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = new byte[16];
            secureRandom.nextBytes(byArray);
            byArray[6] = (byte)(byArray[6] & 0xF);
            byArray[6] = (byte)(byArray[6] | 0x40);
            byArray[8] = (byte)(byArray[8] & 0x3F);
            byArray[8] = (byte)(byArray[8] | 0x80);
            return new GUID(byArray);
        }

        public byte[] toByteArray() {
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[]{(byte)(this.Data1 >> 24), (byte)(this.Data1 >> 16), (byte)(this.Data1 >> 8), (byte)(this.Data1 >> 0)};
            byte[] byArray3 = new byte[]{(byte)(this.Data2 >> 24), (byte)(this.Data2 >> 16), (byte)(this.Data2 >> 8), (byte)(this.Data2 >> 0)};
            byte[] byArray4 = new byte[]{(byte)(this.Data3 >> 24), (byte)(this.Data3 >> 16), (byte)(this.Data3 >> 8), (byte)(this.Data3 >> 0)};
            System.arraycopy(byArray2, 0, byArray, 0, 4);
            System.arraycopy(byArray3, 2, byArray, 4, 2);
            System.arraycopy(byArray4, 2, byArray, 6, 2);
            System.arraycopy(this.Data4, 0, byArray, 8, 8);
            return byArray;
        }

        public String toGuidString() {
            String string = "0123456789ABCDEF";
            byte[] byArray = this.toByteArray();
            StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
            stringBuilder.append("{");
            for (int i = 0; i < byArray.length; ++i) {
                char c = "0123456789ABCDEF".charAt((byArray[i] & 0xF0) >> 4);
                char c2 = "0123456789ABCDEF".charAt(byArray[i] & 0xF);
                stringBuilder.append(c).append(c2);
                if (i != 3 && i != 5 && i != 7 && i != 9) continue;
                stringBuilder.append("-");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        protected void writeFieldsToMemory() {
            for (String string : this.getFieldOrder()) {
                this.writeField(string);
            }
        }

        public static class ByReference
        extends GUID
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(GUID gUID) {
                super(gUID.getPointer());
                this.Data1 = gUID.Data1;
                this.Data2 = gUID.Data2;
                this.Data3 = gUID.Data3;
                this.Data4 = gUID.Data4;
            }

            public ByReference(Pointer pointer) {
                super(pointer);
            }
        }

        public static class ByValue
        extends GUID
        implements Structure.ByValue {
            public ByValue() {
            }

            public ByValue(GUID gUID) {
                super(gUID.getPointer());
                this.Data1 = gUID.Data1;
                this.Data2 = gUID.Data2;
                this.Data3 = gUID.Data3;
                this.Data4 = gUID.Data4;
            }

            public ByValue(Pointer pointer) {
                super(pointer);
            }
        }
    }
}

