/*
 * Decompiled with CFR 0.152.
 */
package com.azuriom.azauth.gson;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.UUID;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class UuidAdapter
extends TypeAdapter<UUID> {
    @Override
    public void write(JsonWriter jsonWriter, UUID uUID) throws IOException {
        jsonWriter.value(uUID.toString());
    }

    @Override
    public UUID read(JsonReader jsonReader) throws IOException {
        String string = jsonReader.nextString();
        try {
            if (string.length() == 32) {
                return this.fromUndashed(string);
            }
            return UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonSyntaxException("Failed parsing '" + string + "' as UUID", illegalArgumentException);
        }
    }

    private UUID fromUndashed(String string) {
        return new UUID(Long.parseUnsignedLong(string.substring(0, 16), 16), Long.parseUnsignedLong(string.substring(16), 16));
    }
}

